package com.bcxin.ars.dao.sb;


import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.ArmtrainorgSearchDto;
import com.bcxin.ars.model.sb.Armtrainorg;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface ArmtrainorgDao {
    /**
     * 根据ID查询
     * @param id
     * @return
     */
    Armtrainorg findById(Long id);

    Armtrainorg findByIdWithOutCache(Long id);
    /**
     *
     * @Decription:批量查询
     * @author：zhongjianhui
     * @method  findByBatchId
     * @date：2018/8/17 9:17
     * @params： * @param approvalList
     * @return java.util.List<com.bcxin.ars.model.sb.Armtrainorg>
     */
    List<Armtrainorg> findByBatchId(@Param("approvalList") List<Approval> approvalList);

    List<Armtrainorg> findByBatchIdWithOutCache(@Param("approvalList") List<Approval> approvalList);


    /**
     *
     * @Decription:批量更新
     * @author：zhongjianhui
     * @method  updateBatch
     * @date：2018/8/17 9:20
     * @params： * @param approvalList
     * @return void
     */
    void updateBatch(@Param("approvalList")List<Armtrainorg> approvalList);

    /**
     * 保存
     */
    Long save(Armtrainorg armtrainorg);

    /**
     * 更新
     * @param armtrainorg
     */
    void update(Armtrainorg armtrainorg);

    /**
     * 暂存查询
     * @param userid
     * @return
     */
    Armtrainorg findByUser(Long userid);

    List<Armtrainorg> search(ArmtrainorgSearchDto dto);

    Long searchCount(ArmtrainorgSearchDto dto);

    void updateCensorStatus(Armtrainorg armtrainorg);

    List<Armtrainorg> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    int countArmtrainorgList(Map<Object, Object> p);

    List<Map<Object,Object>>  searchArmtrainorgList(Map<Object, Object> p);

    Armtrainorg findApproveByOrgname(String orgname);

    List<Map<Object,Object>>  searchForPage(ArmtrainorgSearchDto searchDto, AjaxPageResponse<Armtrainorg> page);
}