package com.bcxin.ars.dao.msg;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.msg.NewsnoticeRecipient;
import org.apache.ibatis.annotations.Param;

public interface NewsnoticeRecipientDao {
    
	void delete(NewsnoticeRecipient recipient);
	
	void deleteByNoticePoliceId(NewsnoticeRecipient recipient);

    Long save(NewsnoticeRecipient recipient);

    void update(NewsnoticeRecipient recipient);

    NewsnoticeRecipient findById(Long id);

	List<NewsnoticeRecipient> findByNoticePoliceId(Long noticePoliceId);

    /**
     * 内导外数据
     * @param startDate 开始时间
     * @return
     */
    List<NewsnoticeRecipient> searchFromInToOutForExport(String startDate);

    void saveForDS(NewsnoticeRecipient newsnoticeRecipient);

    void updateForDS(NewsnoticeRecipient newsnoticeRecipient);

    List<NewsnoticeRecipient> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * @Decription:批量查询
     * @param list
     * @return
     */
    List<NewsnoticeRecipient> findByBatchId(@Param("list")List<NewsnoticeRecipient> list);

    /**
     * @Decription:批量保存修改
     * @param list
     * @return
     */
    void saveBatch(@Param("list")List<NewsnoticeRecipient> list);
}