package com.bcxin.ars.dao.gx;

import com.bcxin.ars.model.gx.InternetPlusBusiness;
import com.bcxin.ars.model.gx.InternetPlusBusiness;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 广西一体化申报请求数据Dao接口
 * 
 * @author lin
 * @date 2022-04-13
 */
public interface InternetPlusBusinessDao {

    /****
     * 删除
     * @param internetPlusBusinessV
     * @return
     */
    int delete(InternetPlusBusiness internetPlusBusinessV);

    /****
     * 保存
     * @param internetPlusBusinessV
     * @return
     */
    int save(InternetPlusBusiness internetPlusBusinessV);

    /****
     * 主键查询
     * @param id
     * @return
     */
     InternetPlusBusiness findById(Long id);

    /****
     * 选择修改
     * @param internetPlusBusinessV
     * @return
     */
    int updateSelective(InternetPlusBusiness internetPlusBusinessV);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<InternetPlusBusiness> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<InternetPlusBusiness> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<InternetPlusBusiness> findByBatchId(@Param("list") List<InternetPlusBusiness> list);


    InternetPlusBusiness findBySdono(String sdono);

    InternetPlusBusiness findByBusinessId(Long businessId);
}
