package com.bcxin.ars.dao.certificate;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.certificate.SecurityCertificateImPortDto;
import com.bcxin.ars.dto.certificate.SecurityCertificateSearchDto;
import com.bcxin.ars.dto.page.SecurityCertificateDto;
import com.bcxin.ars.dto.page.SecurityCertificatePageSearchDto;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.sb.Personcertificate;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;
import java.util.Set;

public interface SecurityCertificateDao {



    void updateHeadImg(@Param("idnum")String idnum,@Param("imgpath")String imgpath);

    void delete(SecurityCertificate personCertificate);

    Long save(SecurityCertificate personCertificate);

    SecurityCertificate findById(Long id);

    void update(SecurityCertificate personCertificate);
    /***
     * 更新状态标识
     * @param personCertificate
     */
    void updateByIdnumBj(SecurityCertificate personCertificate);


    void updateHavePhotodByIdnum(SecurityCertificate personCertificate);

    List<SecurityCertificate> search(SecurityCertificateSearchDto dto);

    Long searchCount(SecurityCertificateSearchDto dto);

    /**
     * 根据申请ID查询证书信息
     * @param securitypersonid
     * @return
     */
    SecurityCertificate findBySecuritypersonid(long securitypersonid);

    String searchMaxZsbhCount(SecurityCertificateSearchDto searchdto);

    /**
     * 批量打印
     * @param dto
     * @return
     */
    List<SecurityCertificate> findBySecuritypersonidArr(SecurityCertificateSearchDto dto);

    List<SecurityCertificate> findByIdArr(@Param("idArr") Long[] idArr);





    /**
     * 批量更新打印状态
     * @param idArray
     */
    void updatePrintedByidArr(Long[] idArray);



    /**
     * 批量修改isDraw 状态为 待推送
     * @param list
     */
    void updateBatchByidNum(@Param("list")List<String> list,@Param("isState") String isState);





    /**
     * 更新打印状态用于北京
     * @param personCertificate
     */
    void updatePrinteStateForBj(SecurityCertificate personCertificate);
    /**
     * 更新打印次数
     * @param personCertificate
     */
    void updatePrinteCount(SecurityCertificate personCertificate);

    List<SecurityCertificate> findPrintBySecuritypersonidArr(Long[] idArray);

    List<SecurityCertificate>  findDetail(SecurityCertificateSearchDto dto);

    /**
     * 内导外数据
     * @param startDate 开始时间
     * @return
     */
    List<SecurityCertificate> searchUpdateflagForExport(String startDate);

    List<SecurityCertificate> searchForDataSynchronization(DataSynchronizationSearchDto dto);


    /**
     *  是否抽取状态更新状态
     * @param idNum
     */
    int updateIisDrawByIdNum(@Param("idNum") String  idNum, @Param("isState") String isState);

    /**
     * 更新状态
     * @param id
     */
    void updateFlagForDS(Long id);
    /**
     * 北京证书同步到内网更新字段 ，打印状态、打印次数
     * @param cer 证书信息
     */
    void updateForBJDS(SecurityCertificate cer);
    /**
     * 根据身份证号查询
     * @param cardnumber
     * @return
     */
    SecurityCertificate findByIdnum(String cardnumber);

    /**
     * 根据身份证号查询(用于北京)
     * @param cardnumber
     * @return
     */
    SecurityCertificate findByIdnumForBj(String cardnumber);
    /**
     * 批量证书领取状态
     * @param idArr 保安员资格证ID列表
     * @return 无
     * @desc edit 2019-03-30 subh 14:33
     */
    void updateReceiveState(@Param("idArr")Long[] idArr);


    /***
     * 培训机构保安员证书查询
     * @param dto 查询条件参数
     * @param ajaxPageResponse 返回数据对象
     * @return 查询列表
     */
    List<SecurityCertificate> searchForTrain(SecurityCertificateSearchDto dto, AjaxPageResponse<Personcertificate> ajaxPageResponse);

    void saveBatch(@Param("certList") List<SecurityCertificate> list);

    List<SecurityCertificate> findByBatchId(List<SecurityCertificate> list);

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    List<SecurityCertificateDto> searchForPage(SecurityCertificatePageSearchDto dto, AjaxPageResponse<SecurityCertificateDto> page);

    /**
     * 获取详情
     * @param id
     * @return
     */
    SecurityCertificate getDetail(Long id);

    /**
     * 批量更新电子证书地址
     * @param list
     */
    void batchSaveElectronCerUrl(@Param("certList") List<SecurityCertificate> list);

    void batchSaveElectronCerUrl2(@Param("certList") List<SecurityCertificate> list);

    List<SecurityCertificate> findOldDataForPerson();

    /***
     * 证书内网同步到外网，北京打印在外网，只需要更新 updateflag 和updatetime 即可
     * @param list 证书列表
     */
    void saveBatchForImportOutBj(@Param("certList") List<SecurityCertificate> list);

    List<SecurityCertificateImPortDto> prc_batchImportCertificate_query(Map<String, Object> paramMap);

    List<SecurityCertificate> findByPersoncertificateIds(@Param("list")List<Personcertificate> list);

    void updateSnapshotId(SecurityCertificate securityCertificate);
    void updateBatchSnapshotId(@Param("list")List<SecurityCertificate> list);

    List<String> selectIdNums(@Param("idNums") List<String> idNums);

    void updateIsDraw(@Param("idNums")List<String> idNums);




    List<SecurityCertificate> findByIdNums(@Param("list") String[] idNums);


    List<SecurityCertificate> findUnPushToSAAS();

    void batchUpdatePushState(@Param("list") List<SecurityCertificate> list);

    void resetDraw(@Param("idNum")String idNumber,@Param("headImg") String headImg);

    void updateOldCerState(SecurityCertificate securityCertificate);

    /**
     * 保安员资格证公共查询方法
     *
     * @param idnum 身份证号参数
     */
    List<SecurityCertificateDto> searchaAcordingToIdNumber(@Param("idnum") String idnum);

    List<String> findNoPhotoList();

    List<String> listIdNumbers(@Param("idNumbers") Set<String> idNumbers);

    void updatePushState(@Param("idNnums")List<String> idNnums, @Param("pushState") boolean pushState);

}