package com.bcxin.ars.dao.certificate;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.CertificatePrintLogSearchDto;
import com.bcxin.ars.model.certificate.CertificatePrintLog;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/***
 * 资格证打印日志息数据层
 * @author subh
 */
public interface CertificatePrintLogDao {
    /***
     * 资格证打印日志查询
     * @param searchDto 查询条件参数
     * @param ajaxPageResponse 返回数据对象
     * @return 查询列表
     */
    List<CertificatePrintLog> query(CertificatePrintLogSearchDto searchDto, AjaxPageResponse<CertificatePrintLog> ajaxPageResponse);

    /***
     * 保存
     * @param certificatePrintLog 等级证信息
     * @return
     */
    void save(CertificatePrintLog certificatePrintLog);

    /**
     * 查询需要生成同步文件的等级证书记录
     * @param dto
     * @return
     */
    List<CertificatePrintLog> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    /***
     * 根据ID查询
     * @param id 主键
     * @return
     */
    CertificatePrintLog findById(Long id);

}
