package com.bcxin.ars.dao.approve;

import java.util.List;
import java.util.Map;

import com.bcxin.ars.dto.approve.ApproveTempDto;
import com.bcxin.ars.dto.approve.CheckTempConfigDto;
import com.bcxin.ars.model.approve.ApproveTemp;
import org.apache.ibatis.annotations.Param;

/**
 * @author：wangcy @date：2018/01/16 0016 19:46
 * @description：审批模板dao
 */
public interface ApproveTempDao {

    /**
     * 获取模板数据
     *
     * @return
     */
    List<ApproveTempDto> findDto(Long policeId);

    /**
     * @Author: wangcy
     * @Description:获取模板
     * @Date: 2018/01/19 0019 10:53
     */
    ApproveTemp findById(Long id);
    /**
     * @Author: wangcy
     * @Description:获取模板
     * @Date: 2018/01/19 0019 10:53
     */
    ApproveTemp findByForTempCode(String tempCode);

    /**
     * @Author: wangcy
     * @Description:修改模板信息
     * @Date: 2018/01/19 0019 10:53
     */
    void update(ApproveTemp approveTemp);

    /**
     * 根据审批模板ID获取最大审批层级
     *
     * @param approveTempId
     * @return
     */
    String getMaxApproveLevelByApproveTempId(Long approveTempId);

    /**
     * 根据审批模板ID和城市代码获取最大审批层级
     *
     * @param approveTempId
     * @return
     */
    String getMaxApproveLevelByApproveTempIdAndCityCode(CheckTempConfigDto checkDto);

    /**
     * 根据最大层次返回公安机构信息
     */
    List<Map> getPoliceListByMaxApproveLevel(String maxApproveLevel, Long policeId);

    List<ApproveTemp> insertBatchApproveTemp(List<ApproveTemp> list);

    /**
     * 根据父模板ID获取子模板列表
     *
     * @param parentTempId
     * @return
     */
    List<ApproveTemp> findByParentTempId(Long parentTempId);

    List<ApproveTemp> findApproveOrgListSj(Long parentPoliceId);

    ApproveTemp findByTempCode(String tempCode);
    String findProcessInfoByTempId(Long TempId,@Param("policeIds") String[] policeIds);

    List<ApproveTemp> findAll();

    /**
     * 获取审批机构id
     * @param tempCode
     * @param policeIds
     * @return
     */
    Long getApprovalOrgId(@Param("tempCode")String tempCode, @Param("policeIds")List<String> policeIds);

}
