package com.bcxin.ars.dao;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ThirdTrainBackgroundPageSearchDto;
import com.bcxin.ars.model.ThirdTrainBackground;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 第三方背景筛查Dao接口
 *
 * @author lin
 * @date 2021-04-26
 */
public interface ThirdTrainBackgroundDao {

    /****
     * 删除
     * @param thirdTrainBackground
     * @return
     */
    int delete(ThirdTrainBackground thirdTrainBackground);

    /****
     * 保存
     * @param thirdTrainBackground
     * @return
     */
    int save(ThirdTrainBackground thirdTrainBackground);

    /****
     * 主键查询
     * @param id
     * @return
     */
    ThirdTrainBackground findById(Long id);

    /****
     * 选择修改
     * @param thirdTrainBackground
     * @return
     */
    int updateSelective(ThirdTrainBackground thirdTrainBackground);

    /**
     * 分页查询
     *
     * @param searchDto
     * @param page
     * @return
     */
    List<ThirdTrainBackground> searchForPage(ThirdTrainBackgroundPageSearchDto searchDto, AjaxPageResponse<ThirdTrainBackground> page);

    /**
     * 外导内查询
     *
     * @param searchDto
     * @return
     */
    List<ThirdTrainBackground> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     *
     * @param startDate
     * @return
     */
    List<ThirdTrainBackground> findDSOutList(String startDate);

    /**
     * 批量保存
     *
     * @param list
     */
    void saveBatch(@Param("list") List<ThirdTrainBackground> list);

    /**
     * 批量查询
     *
     * @param list
     * @return
     */
    List<ThirdTrainBackground> findByBatchId(@Param("list") List<ThirdTrainBackground> list);

    /**
     * 获取该业务id, userId及业务类型的所有数据
     *
     * @param thirdTrainBackgroundSearch
     * @return
     */
    List<ThirdTrainBackground> listPeopleBackgroundScreening(ThirdTrainBackground thirdTrainBackgroundSearch);

    /**
     * 获取未取得结果的记录
     *
     * @return
     */
    List<ThirdTrainBackground> listPeopleForScreening();

    /**
     * userId businessType businessId idNumber
     *
     * @param thirdTrainBackground
     * @return
     */
    int selectCount(ThirdTrainBackground thirdTrainBackground);
}
