package com.bcxin.ars.dao;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SecurityGuardSearchDto;
import com.bcxin.ars.model.SecurityGuard;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface SecurityGuardDao {
    /**
     * @return int
     * @Decription:根据条件查询保安师条数
     * @author：wangjianchi
     * @method countSecurityGuardList
     * @date：2019/3/19 10:16
     * @params： * @param p
     */
    int countSecurityGuardList(Map<Object, Object> p);

    /**
     * @return list
     * @Decription:根据条件查询保安师数据
     * @author：wangjianchi
     * @method searchSecurityGuardList
     * @date：2019/3/19 10:16
     * @params： * @param p
     */
    List<Map<Object, Object>> searchSecurityGuardList(Map<Object, Object> p);

    /**
     * @return 查询结果list
     * @Decription:根据条件分页查询保安师数据
     * @author：wangjianchi
     * @method query
     * @date：2019/3/19 14:16
     * @params： * @param SecurityGuardSearchDto
     */
    List<SecurityGuard> search(SecurityGuardSearchDto dto, AjaxPageResponse<SecurityGuard> page);

    /**
     * @return list
     * @Decription:根据ID查询保安师信息
     * @author：wangjianchi
     * @method findById
     * @date：2019/3/20 14:16
     * @params： * @param SecurityGuard
     */
    SecurityGuard findById(Long id);

    SecurityGuard findByIdWithOutCache(Long id);

    /**
     * @return SecurityGuard
     * @Decription:根据身份证号查询保安师信息
     * @author：wangjianchi
     * @method findByIdNum
     * @date：2019/3/20 14:16
     * @params： * @param SecurityGuard
     */
    SecurityGuard findByIdNum(String idNum);

    /**
     * @return
     * @Decription:保存新保安师信息
     * @author：wangjianchi
     * @method findById
     * @date：2019/3/22 14:16
     * @params： * @param SecurityGuard
     */
    void save(SecurityGuard securityGuard);

    /**
     * @return
     * @Decription:根据ID更新保安师信息
     * @author：wangjianchi
     * @method update
     * @date：2019/3/22 14:16
     * @params： * @param SecurityGuard
     */
    void update(SecurityGuard securityGuard);

    /**
     * @return
     * @Decription:导入保安师数据到临时表
     * @author：wangjianchi
     * @method insertTempBatchGuardImport
     * @date：2019/3/27 09:16
     * @params： * @param subList importBatchId
     */
    void insertTempBatchGuardImport(@Param("subList")List<Map<String, String>> subList,@Param("importBatchId") Long importBatchId);

    /**
     * @return
     * @Decription:查询本次校验失败的导入保安师信息
     * @author：wangjianchi
     * @method getTempImportGuardList
     * @date：2019/3/27 09:17
     * @params： * @param importBatchId
     */
    List<Map<String, String>> getTempImportGuardList(Long importBatchId);

    /**
     * @return
     * @Decription:删除本次导入的保安师信息
     * @author：wangjianchi
     * @method deleteTempBatchGuardImport
     * @date：2019/3/27 09:18
     * @params： * @param importBatchId
     */
    void deleteTempBatchGuardImport(Long importBatchId);

    /**
     * @return
     * @Decription:验证导入的Excel是否有重复身份证数据
     * @author：wangjianchi
     * @method checkIdNumNoRepeat
     * @date：2019/3/27 09:18
     * @params： * @param importBatchId
     */
    void checkIdNumNoRepeat(Long importBatchId);

    /**
     * @return
     * @Decription:验证需要导入的数据身份证是否已存在保安师库
     * @author：wangjianchi
     * @method checkInOtherCom
     * @date：2019/3/27 09:18
     * @params： * @param importBatchId
     */
    void checkInOtherCom(Long importBatchId);

    /**
     * @return
     * @Decription:批量插入保安师数据
     * @author：wangjianchi
     * @method insertSecurityGuardInfo
     * @date：2019/3/27 09:18
     * @params： * @param importBatchId
     */
    void insertSecurityGuardInfo(Long importBatchId);

    /**
     * @Decription:搜索有修改待同步到外网的数据
     * @param startDate 开始时间
     * @return
     */
    List<SecurityGuard> searchForExport(String startDate);

    /**
     * @Decription:通过主键id批量查询
     * @param list
     * @return
     */
    List<SecurityGuard> findByBatchId(@Param("list")List<SecurityGuard> list);

    List<SecurityGuard> findByBatchIdWithOutCache(@Param("list")List<SecurityGuard> list);

    /**
     * @Decription:批量保存
     * @param list
     */
    void saveBatch(@Param("list")List<SecurityGuard> list);

    /**
     * @Decription:搜索同步到内网的数据
     * @param dto
     * @return
     */
    List<SecurityGuard> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    /**
     * @Decription:外到内更新修改标志
     * @param list
     * @return
     */
    void updateFlagForOutToIn(List<SecurityGuard> list);

    /**
     * 通过身份证号批量更新
     * @param idNums
     * @param securityGuard
     */
    void batchUpdateByIdNums(@Param("idNums")List idNums,@Param("securityGuard") SecurityGuard securityGuard);
    /**
     * 通过身份证号批量查询
     * @param idNums
     */
    List<SecurityGuard> findByIdNums(@Param("list")List idNums);

    List<SecurityGuard> findByIdNumsWithOutCache(@Param("list")List idNums);
}