package com.bcxin.ars.dao;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.SecurityCompanySchedule;

/**
 * 安保公司班次数据类
 * @author Ethan
 */
public interface SecurityCompanyScheduleDao {
	
	/**
	 * 获取指定安保公司的班次
	 * @return
	 */
	List<SecurityCompanySchedule> findByCompanyId(Long companyId);
	
	/**
	 * 根据Id获取班次信息
	 * @param id
	 * @return
	 */
	SecurityCompanySchedule findById(Long id);
	
	/**
	 * 保存班次信息
	 * @param schedule
	 * @return
	 */
	Long save(SecurityCompanySchedule schedule);
	
	Long saveForDS(SecurityCompanySchedule schedule);

	/**
	 *
	 * @param id
	 * @return
	 */
	long findByCompanyIdWithTask(long id);
	
	/**
	 * 更新班次信息
	 * @param schedule
	 */
	void update(SecurityCompanySchedule schedule);
	
	/**
	 * 删除指定班次
	 * @param schedule
	 */
	void delete(SecurityCompanySchedule schedule);

	List<SecurityCompanySchedule> searchForDataSynchronization(DataSynchronizationSearchDto dto);
}
