package com.bcxin.ars.dao;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbSubsidiaryManagerSearchDto;
import com.bcxin.ars.model.SbSubsidiaryManager;

import java.util.List;

public interface SbSubsidiaryManagerDao {
	/**
	 * 查询
	 * @param sbSubsidiaryBaseSearchDto
	 * @return
	 */
	List<SbSubsidiaryManager> search(SbSubsidiaryManagerSearchDto sbSubsidiaryBaseSearchDto);

	/**
	 * 保存
	 * @param sbSubsidiaryManager
	 * @return
	 */
	Long save(SbSubsidiaryManager sbSubsidiaryManager);

	/**
	 * 删除
	 * @param sbSubsidiaryManager
	 * @return
	 */
	Long delete(SbSubsidiaryManager sbSubsidiaryManager);

	/**
	 * 根据ID查询
	 * @param id
	 * @return
	 */
	SbSubsidiaryManager findById(Long id);

	/**
	 * 统计
	 * @return
	 */
	long count(SbSubsidiaryManagerSearchDto dto);

	/**
	 * 更新子公司基础信息
	 * @param sbSubsidiaryManager
	 */
	void update(SbSubsidiaryManager sbSubsidiaryManager);

	List<SbSubsidiaryManager> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveForDS(SbSubsidiaryManager sbSubsidiaryManager);


}
