package com.bcxin.ars.dao;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbRewardSearchDto;
import com.bcxin.ars.model.SbPunish;
import com.bcxin.ars.model.SbReward;

import java.util.List;

public interface SbRewardDao {

	/**
	 * 查询
	 * @param sbRewardSearchDto
	 * @return
	 */
	List<SbReward> search(SbRewardSearchDto sbRewardSearchDto);

	/**
	 * 保存
	 * @param sbReward
	 * @return
	 */
	Long save(SbReward sbReward);

	/**
	 * 删除
	 * @param sbReward
	 * @return
	 */
	Long delete(SbReward sbReward);

	/**
	 * 根据ID查询
	 * @param id
	 * @return
	 */
	SbReward findById(Long id);

	/**
	 * 统计
	 * @return
	 */
	long count(SbRewardSearchDto dto );

	/**
	 * 更新保安奖励信息
	 * @param sbReward
	 */
	void update(SbReward sbReward);

	List<SbReward> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveForDS(SbReward sbReward);


	/**
	 * 根据awardId查询
	 * @param awardId
	 * @return
	 */
	List<SbReward> findByAwardId(Long awardId);


	/**
	 * 根据身份证查询
	 * @param idNum
	 * @return
	 */
	List<SbReward> findByIdNum(String idNum);

	/**
	 * 删除
	 * @param awardId
	 * @return
	 */
	void deleteByawardId(Long awardId);

	/**
	 * 更新
	 * @param sbReward
	 * @return
	 */
	void updateByawardId(SbReward sbReward);
}
