package com.bcxin.ars.dao;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbBusinessOutsideManagementSearchDto;
import com.bcxin.ars.dto.sb.SbSubsidiaryBaseSearchDto;
import com.bcxin.ars.model.SbBusinessOutsideManagement;
import com.bcxin.ars.model.SbSubsidiaryBase;

import java.util.List;

public interface SbBusinessOutsideManagementDao {

	/**
	 * 查询
	 * @param sbSubsidiaryBaseSearchDto
	 * @return
	 */
	List<SbBusinessOutsideManagement> search(SbBusinessOutsideManagementSearchDto sbSubsidiaryBaseSearchDto);
	Long saveById(SbBusinessOutsideManagement sbBusinessOutsideManagement);
	/**
	 * 保存
	 * @param sbBusinessOutsideManagement
	 * @return
	 */
	Long save(SbBusinessOutsideManagement sbBusinessOutsideManagement);

	/**
	 * 删除
	 * @param sbBusinessOutsideManagement
	 * @return
	 */
	Long delete(SbBusinessOutsideManagement sbBusinessOutsideManagement);

	/**
	 * 根据ID查询
	 * @param id
	 * @return
	 */
	SbBusinessOutsideManagement findById(Long id);

	/**
	 * 统计
	 * @return
	 */
	long count(SbBusinessOutsideManagementSearchDto sbSubsidiaryBaseSearchDto);

	/**
	 * 海外经营信息管理
	 * @param sbBusinessOutsideManagement
	 */
	void update(SbBusinessOutsideManagement sbBusinessOutsideManagement);

	List<SbBusinessOutsideManagement> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveForDS(SbBusinessOutsideManagement sbBusinessOutsideManagement);


}
