package com.bcxin.ars.dao;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.PoliceRoleSearchDto;
import com.bcxin.ars.dto.page.PoliceRoleDto;
import com.bcxin.ars.dto.page.RolePageSearchDto;
import com.bcxin.ars.model.PoliceRole;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface PoliceRoleDao {

	PoliceRole findById(long id);
	
	Long save(PoliceRole policeRole);
	
	void update(PoliceRole policeRole);
	
	List<PoliceRole> search(PoliceRoleSearchDto dto);
	
	Long searchCount(PoliceRoleSearchDto dto);

	void delete(PoliceRole policeRole);

	PoliceRole findByOrgIdAndRoleName(Long orgid, String rolename);
	
	List<PoliceRole> findByUserId(Long userid);
	
	List<PoliceRole> findByRoleId(PoliceRoleSearchDto dto);

	List<PoliceRole> findAll();

	void saveForDS(PoliceRole policeRole);

	List<PoliceRole> searchForUser(PoliceRoleSearchDto dto);


	List<PoliceRole> searchForExport();

	/**
	 * 更新新增修改标志
	 * @param policeRole
	 */
	void updateFlag(PoliceRole policeRole);

	List<PoliceRole> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外数据
     * @param startDate 开始时间
     * @return
     */
	List<PoliceRole> searchFromInToOutForExport(String startDate);


	/**
	 * 根据公安机构ID删除公安角色
	 * @param orgId
	 * by llc 2018-08-28
	 */
	int deleteRoleByOrgId(Long orgId);

    List<PoliceRole> findByBatchId(@Param("list")List<PoliceRole> list);

	void saveBatch(@Param("list")List<PoliceRole> list);

    List<PoliceRole> searchForPage(RolePageSearchDto dto, AjaxPageResponse<PoliceRoleDto> page);
	PoliceRole findPoliceRole(String orgId);
}
