package com.bcxin.ars.dao;

import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.sb.PoliceSearchDto;
import com.bcxin.ars.model.Police;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface PoliceDao {

	/**
	 * 查询
	 * @param policeSearchDto
	 * @return
	 */
	List<Police> search(PoliceSearchDto policeSearchDto);

	/**
	 * 查询
	 * @param policeSearchDto
	 * @return
	 */
	List<Police> searchAll(PoliceSearchDto policeSearchDto);

	List<Tree> searchForTree(PoliceSearchDto policeSearchDto);

	List<LayTree> searchForLayTree(PoliceSearchDto policeSearchDto);

	List<MenuTree> searchForMenuTree(PoliceSearchDto policeSearchDto);

	List<Police> searchArea(PoliceSearchDto policeSearchDto);

	List<Police> findByParentOrg(Long parentorg);

	List<TreeView> findTreeViewByParentId(Long parentorg);

	List<TreeView> searchForTreeView(PoliceSearchDto policeSearchDto);

	List<TreeView> searchForTreeViewByprint(PoliceSearchDto policeSearchDto);
	/**
	 *
	 * @Decription:查询一级的机构
	 * @author：zhongjianhui
	 * @method  searchPoliceForTreeViewByprint
	 * @date：2018/11/28 14:36
	 * @params： * @param policeSearchDto
	 * @return java.util.List<com.bcxin.ars.dto.TreeView>
	 */
	List<TreeView> searchPoliceForTreeViewByprint(PoliceSearchDto policeSearchDto);

	List<Police> searchParentorg(Police police);

	/**
	 * 保存
	 * @param police
	 * @return
	 */
	Long save(Police police);


	/**
	 * 删除
	 * @param police
	 * @return
	 */
	Long delete(Police police);

	/**
	 * 根据ID查询
	 * @param id
	 * @return
	 */
	Police findById(Long id);

	/**
	 * 根据机构名称查询
	 * @param orgname
	 * @return
	 */
	Police findByOrgname(String orgname);

	/**
	 * 统计
	 * @return
	 */
	long count(PoliceSearchDto dto);

	/**
	 * 更新机构管理信息
	 * @param police
	 */
	void update(Police police);
	
	void updateForDS(Police police);
	/***
	 * 根据ID获取区域列表
	 * @param police
	 * @return
	 */
	List<Police>  findByAreaUserId(Police police);
	
	List<Police> findAll();

	/**
	 * 根据区域编码查询police
	 * @param police
	 * @return
	 */
	List<Police>  findPoliceByAreacode(Police police);

	void saveForDS(Police police);

    /**
     * 内导外数据
     * @param startDate 开始时间
     * @return
     */
	List<Police> searchForExport(String startDate);

	/**
	 * 更新新增修改标志
	 * @param police
	 */
	void updateFlag(Police police);

	List<Police> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);
	
	List<Police> findPoliceByOrgTypeAndLikeAreacode(String maxApproveLevel, String areacode);

	/**
	 * 新审批配置：根据区域编码查询police
	 * @param police
	 * @return
	 */
	List<Police>  findPoliceByAreacodeApprove(Police police);


	/**
	 * 更新 是否导出isexport标志位
	 * @param policeSearchDto
	 * @return void
	 */
    void updateExport(PoliceSearchDto policeSearchDto);

	/**
	 * 与saas对接
	 *  机构查询
	 * @param policeSearchDto
	 * @return
	 */
	List<PoliceDto> searchForSaas(PoliceSearchDto policeSearchDto);

    List<Police> findByBatchId(@Param("list")List<Police> list);

	void saveBatch(@Param("list")List<Police> list);
/***
	 * 根据用户ID获取数据权限机构编码列表
	 * @param userId 用户ID
	 * @return  机构编码列表
	 */
	List<Police>  findDataPoliceForUserID(Long userId);
    /**
     * 获取当前市级最小级机构
     * @param tempCode 审批流程key
     * @return 最小级的机构
     */
    Police getApprovalMinOrgTypePolice(@Param("tempCode")String tempCode);

    String findOrgNameByOrgIds(@Param("list")String[] orgIds);

	List<Police> findByOrgIds(@Param("list")String[] orgIds);

	Police findByOrgIdsAndOrgType(@Param("list")String[] orgIds,@Param("orgType") String orgType);

    /**
     * 根据编码获取区县机构信息
     * @param areaCode 编码
     * @return 机构信息
     */
    Police findByAreaCode(@Param("areaCode")String areaCode);

    /***
     * 根据类型获取机构列表
     * @param type
     * @return
     */
    List<Police> findByType(@Param("type") String type);
    String selectOrgNameById(@Param("orgId")String orgId);

	/**
	 * 根据机构编码获取机构信息
	 * @param code
	 * @return
	 */
	Police findByCode(String code);
}
