package com.bcxin.ars.dao;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.OrganizationSAASDTO;
import com.bcxin.ars.model.Organization;
import com.bcxin.ars.model.OrganizationDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface OrganizationDao {

	Long save(Organization org); 
	
	void update(Organization org);
	/**
	 *
	 * @Decription:批量新增修改
	 * @author：zhongjianhui
	 * @method  updateBatch
	 * @date：2018/11/20 15:45
	 * @params： * @param organizationDTOList
	 * @return com.bcxin.ars.model.Organization
	 */
	void updateBatch(@Param("organizationDTOList") List<OrganizationSAASDTO> organizationDTOList);

	void delete(Organization org);
	
	Organization findById(Long id);

	Organization findSingleById(Long id);
	/**
	 *
	 * @Decription:批量查询
	 * @author：zhongjianhui
	 * @method  findByBatchId
	 * @date：2018/11/20 15:45
	 * @params： * @param organizationDTOList
	 * @return com.bcxin.ars.model.Organization
	 */
	List<Organization> findByBatchId(@Param("organizationDTOList") List<OrganizationSAASDTO> organizationSAASDTOList);

	List<Organization> findByCompany(Long companyId);
	
	List<Organization> findByParentId(Long parentId);

	Organization findByCompanyWithSaasSpecial(Long companyId);

	List<Organization> searchForDataSynchronization(DataSynchronizationSearchDto dto);

	Long saveForDS(Organization organization);

	/***
	 * 查询某个组织机构的保安人员人数
	 * @param organization
	 * @return
	 */
	Long queryCount(Organization organization);

	/***
	 * 根据公司ID查询全部
	 * @param companyId 公司ID
	 * @return 部门列表
	 */
	List<Organization> findByCompanyAll(Long companyId);

	/***
	 * 通过单位ID查出所有部门信息
	 * @param companyId
	 * @return
	 * by llc 2018-08-29
	 */
	List<OrganizationDto> findOrgInfoByCompanyId(long companyId);

	/***
	 * 通过单位ID或者上级id查出所有部门信息
	 * @param orgDto
	 * @return
	 * by llc 2018-08-29
	 */
    List<OrganizationDto> findByParentIdAndCompanyId(OrganizationDto orgDto);
}
