package com.bcxin.ars.dao;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.OrderSearchDto;
import com.bcxin.ars.model.Order;

/**
 * 订单数据访问类
 * @author Ethan
 */
public interface OrderDao {
	
	void save(Order order);
	
	public Order findById(Long id);

	Order findByOrderNo(String orderNo);

	void update(Order order);

	List<Order> findByUserid(Long userid);

	List<Order> findByTrainorgid(OrderSearchDto dto);

	long countOrder(OrderSearchDto dto);

	List<Order> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void delete(Order order);

	void saveForDS(Order order);

	Order findByRandomOrderNo(String orderNo);

	List<String> checkExistOrderByPersonIds(Long[] personIds,String traintype);
}