package com.bcxin.ars.dao;

import java.util.List;

import com.bcxin.ars.model.Native;

/**
 * 省市区数据类
 * @author Ethan
 */
public interface NativeDao {
	
	/**
	 * 根据指定编号获取区域信息
	 * @param code
	 * @return
	 */
	Native findByCode(Long code);
	
	/**
	 * 获取省数据
	 * @return
	 */
	List<Native> findProvince();
	
	/**
	 * 根据编号获取其下级区域
	 * @param code
	 * @return
	 */
	List<Native> findByParentCode(Long code);
	
	/**
	 * 获取全部省市县数据
	 * @return
	 */
	List<Native> findAll();
	
}
