package com.bcxin.ars.dao;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.CyAssociation;
import com.bcxin.ars.dto.page.CyAssociationPageSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *保安协会Dao
 * @author linqinglin
 * @Date 2020-08-05 22:14:24
 */
public interface CyAssociationDao {

	/****
	 * 删除
	 * @param cyAssociation
	 * @return
	 */
	int delete(CyAssociation cyAssociation);

	/****
	 * 保存
	 * @param cyAssociation
	 * @return
	 */
	int save(CyAssociation cyAssociation);

	/****
	 * 主键查询
	 * @param id
	 * @return
	 */
	CyAssociation findById(Long id);

	/****
	 * 选择修改
	 * @param cyAssociation
	 * @return
	 */
	int updateSelective(CyAssociation cyAssociation);

	/**
	 * 分页查询
	 * @param searchDto
	 * @param page
	 * @return
	 */
	List<CyAssociation> searchForPage(CyAssociationPageSearchDto searchDto, AjaxPageResponse<CyAssociation> page);

	/**
	 * 外导内查询
	 * @param searchDto
	 * @return
	 */
	List<CyAssociation> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	/**
	 * 内导外查询
	 * @param startDate
	 * @return
	 */
	List<CyAssociation> findDSOutList(String startDate);

	/**
	 * 批量保存
	 * @param list
	 */
	void saveBatch(@Param("list") List<CyAssociation> list);

	/**
	 * 批量查询
	 * @param list
	 * @return
	 */
	List<CyAssociation> findByBatchId(@Param("list")List<CyAssociation> list);
}
