package com.bcxin.ars.dao;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.AnnualSurveyReportPageSearchDto;
import com.bcxin.ars.model.AnnualSurveyReport;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 北京保安从业单位和从业人员情况年度调查Dao接口
 * 
 * @author lin
 * @date 2020-11-20
 */
public interface AnnualSurveyReportDao{

    /****
     * 删除
     * @param annualSurveyReport
     * @return
     */
    int delete(AnnualSurveyReport AnnualSurveyReport);

    /****
     * 保存
     * @param annualSurveyReport
     * @return
     */
    int save(AnnualSurveyReport annualSurveyReport);

    /****
     * 主键查询
     * @param id
     * @return
     */
        AnnualSurveyReport findById(Long id);

    /****
     * 选择修改
     * @param annualSurveyReport
     * @return
     */
    int updateSelective(AnnualSurveyReport annualSurveyReport);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<AnnualSurveyReport> searchForPage(AnnualSurveyReportPageSearchDto searchDto, AjaxPageResponse<AnnualSurveyReport> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<AnnualSurveyReport> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<AnnualSurveyReport> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<AnnualSurveyReport> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AnnualSurveyReport> findByBatchId(@Param("list") List<AnnualSurveyReport> list);


    AnnualSurveyReport findByUserId(Long userId);

    AnnualSurveyReport findToTal(String fillYear);

    List<AnnualSurveyReport> findByFillYear(String fillYear);

    AnnualSurveyReport findByUserIdAndFillYear(@Param("userId")Long userId, @Param("fillYear")String fillYear);
}
