/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.webservice.police.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.log.BjRestLogDao;
import com.bcxin.ars.dao.sb.BackgroundApprovalDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.log.BjRestLog;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import com.bcxin.ars.webservice.impl.SNBackGroupCensorServiceImpl;
import com.bcxin.ars.webservice.police.SecurityInterfaceService;
import com.bcxin.ars.webservice.police.enums.ResultType;
import com.bcxin.ars.webservice.util.SubStringUtil;
import com.dragonsoft.node.adapter.comm.RbspCall;
import com.dragonsoft.node.adapter.comm.RbspService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="securityInterfaceService_640000")
public class NXSecurityInterfaceService
implements SecurityInterfaceService {
    private static Logger logger = LoggerFactory.getLogger(SNBackGroupCensorServiceImpl.class);
    @Autowired
    private BjRestLogDao bjRestLogDao;
    @Value(value="${ZAFLAG}")
    private String ZAFLAG;
    @Value(value="${ZAURL}")
    private String ZAURL;
    @Autowired
    private ConfigService configService;
    @Autowired
    private SysareaService sysareaService;
    @Autowired
    private BackgroundApprovalDao backgroundApprovalDao;
    @Autowired
    private RedisUtil redisUtil;

    private String call(String requestID, String serviceID, List<String> idnums, String[] requiredItems, String DataObjectCode, String InfoCodeMode, String idType) {
        String result = "";
        String key = DateUtil.getCurrentDate((String)"yyyyMMdd") + "_" + serviceID;
        String count = this.redisUtil.get(key);
        if (StringUtil.isNotEmpty((String)count)) {
            Long total = Long.parseLong(count);
            Long max = 8000L;
            try {
                String configValue = this.configService.getValueByKey("POLICE_INTERFACE_MAX");
                max = Long.parseLong(configValue);
            }
            catch (Exception configValue) {
                // empty catch block
            }
            if (total >= max) {
                return result;
            }
        }
        this.redisUtil.getCount(key, 7L);
        RbspService service = new RbspService(requestID, serviceID);
        service.setUserCardId("asdfasd");
        service.setUserDept("0100");
        service.setUserName("ptjian");
        RbspCall call = service.createCall();
        call.setUrl(this.ZAURL);
        call.setMethod("Query");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("DataObjectCode", DataObjectCode);
        params.put("InfoCodeMode", InfoCodeMode);
        params.put("Condition", idType + " in (" + SubStringUtil.getStr(idnums) + ")");
        params.put("RequiredItems", requiredItems);
        logger.error("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)this.ZAURL);
        logger.error("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(params));
        result = call.invoke(params);
        logger.error("\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        return result;
    }

    private String call(String requestID, String serviceID, String idnum, String[] requiredItems, String DataObjectCode, String InfoCodeMode, String idType) {
        String result = "";
        String key = DateUtil.getCurrentDate((String)"yyyyMMdd") + "_" + serviceID;
        String count = this.redisUtil.get(key);
        if (StringUtil.isNotEmpty((String)count)) {
            Long total = Long.parseLong(count);
            Long max = 8000L;
            try {
                String configValue = this.configService.getValueByKey("POLICE_INTERFACE_MAX");
                max = Long.parseLong(configValue);
            }
            catch (Exception configValue) {
                // empty catch block
            }
            if (total >= max) {
                return result;
            }
        }
        this.redisUtil.getCount(key, 7L);
        RbspService service = new RbspService(requestID, serviceID);
        service.setUserCardId("asdfasd");
        service.setUserDept("0100");
        service.setUserName("ptjian");
        RbspCall call = service.createCall();
        call.setUrl(this.ZAURL);
        call.setMethod("Query");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("DataObjectCode", DataObjectCode);
        params.put("InfoCodeMode", InfoCodeMode);
        params.put("Condition", idType + "='" + idnum + "')");
        params.put("RequiredItems", requiredItems);
        logger.error("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)this.ZAURL);
        logger.error("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(params));
        result = call.invoke(params);
        logger.error("\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        return result;
    }

    @Override
    public Map<String, PersonBaseInfo> getPersonInfo(List<String> idnums, ResultType resultType) {
        return this.getPersonInfo("C64-00000111", "S64-00000075", idnums, resultType, Constants.NX_CZINFO_DataObjectCode, "002", "GMSFHM");
    }

    @Override
    public Map<String, PersonBaseInfo> getNewPersonInfo(List<String> idnums) {
        return null;
    }

    @Override
    public void censorPerson(List<SecurityPerson> personList) {
        List<String> idnumList = personList.stream().map(SecurityPerson::getIdNumber).collect(Collectors.toList());
        Map<String, PersonBaseInfo> personMap = this.getPersonInfo(idnumList, ResultType.NAME);
        Map<String, PersonBaseInfo> xdMap = this.getPersonInfo("C64-00000111", "S64-00000210", idnumList, ResultType.NAME, Constants.NX_ZDRY_DataObjectCode, "002", "SFZH");
        Map<String, PersonBaseInfo> wfMap = this.getPersonInfo("C64-00000111", "S64-00000211", idnumList, ResultType.NAME, Constants.NX_ZDRY_DataObjectCode, "002", "SFZH");
        Map<String, PersonBaseInfo> dtMap = this.getPersonInfo("C64-00000111", "S64-00000212", idnumList, ResultType.NAME, Constants.NX_ZDRY_DataObjectCode, "002", "SFZH");
        for (SecurityPerson securityPerson : personList) {
            BackgroundApprovalDto dto = new BackgroundApprovalDto();
            dto.setIdNumber(securityPerson.getIdNumber());
            dto.setRealName(securityPerson.getRealName());
            dto.setBusinessid(securityPerson.getId());
            dto.setBusinesstype("15");
            dto.setAuthState(securityPerson.getIdentityAuthState());
            securityPerson.setBackgroundApprovals(this.censor(dto, personMap.get(securityPerson.getIdNumber()), xdMap.get(securityPerson.getIdNumber()), wfMap.get(securityPerson.getIdNumber()), dtMap.get(securityPerson.getIdNumber())));
        }
    }

    @Override
    public void censoRenrollQualification(List<Personcertificate> personList) {
        List<String> idnumList = personList.stream().map(Personcertificate::getCardnumber).collect(Collectors.toList());
        Map<String, PersonBaseInfo> personMap = this.getPersonInfo(idnumList, ResultType.PERSON);
        Map<String, PersonBaseInfo> xdMap = this.getPersonInfo("C64-00000111", "S64-00000210", idnumList, ResultType.NAME, Constants.NX_ZDRY_DataObjectCode, "002", "SFZH");
        Map<String, PersonBaseInfo> wfMap = this.getPersonInfo("C64-00000111", "S64-00000211", idnumList, ResultType.NAME, Constants.NX_ZDRY_DataObjectCode, "002", "SFZH");
        Map<String, PersonBaseInfo> dtMap = this.getPersonInfo("C64-00000111", "S64-00000212", idnumList, ResultType.NAME, Constants.NX_ZDRY_DataObjectCode, "002", "SFZH");
        for (Personcertificate personcertificate : personList) {
            BackgroundApprovalDto dto = new BackgroundApprovalDto();
            dto.setBusinessid(personcertificate.getId());
            dto.setBusinesstype("5");
            dto.setIdNumber(personcertificate.getCardnumber());
            dto.setRealName(personcertificate.getName());
            PersonBaseInfo personBaseInfo = personMap.get(personcertificate.getCardnumber());
            if (personBaseInfo != null && StringUtil.isNotEmpty((String)personBaseInfo.getAddress())) {
                personcertificate.setPopulationAddress(personBaseInfo.getAddress());
            }
            personcertificate.setBackgroundApprovals(this.censor(dto, personBaseInfo, xdMap.get(personcertificate.getCardnumber()), wfMap.get(personcertificate.getCardnumber()), dtMap.get(personcertificate.getCardnumber())));
        }
    }

    @Override
    public void censorNewPerson(List<SecurityPerson> personList) {
    }

    @Override
    public void censorNewQualification(List<Personcertificate> personList) {
    }

    public List<BackgroundApproval> censor(BackgroundApprovalDto dto, PersonBaseInfo czPerson, PersonBaseInfo xdPerson, PersonBaseInfo wfPerson, PersonBaseInfo dtPerson) {
        ArrayList<BackgroundApproval> list = new ArrayList<BackgroundApproval>();
        try {
            BackgroundApproval backgroundApproval = new BackgroundApproval();
            backgroundApproval.setActive(Boolean.valueOf(true));
            backgroundApproval.setCreateTime(new Date());
            backgroundApproval.setUpdateTime(new Date());
            backgroundApproval.setApprovaldate(new Date());
            backgroundApproval.setBusinesstype(dto.getBusinesstype());
            backgroundApproval.setBusinessid(dto.getBusinessid());
            BackgroundApproval cz_BackgroundApproval = backgroundApproval.clone();
            BackgroundApproval xd_BackgroundApproval = cz_BackgroundApproval.clone();
            xd_BackgroundApproval.setLibraryType("2");
            BackgroundApproval dt_BackgroundApproval = cz_BackgroundApproval.clone();
            dt_BackgroundApproval.setLibraryType("3");
            BackgroundApproval wf_BackgroundApproval = cz_BackgroundApproval.clone();
            dt_BackgroundApproval.setLibraryType("4");
            if (czPerson != null) {
                if (StringUtil.isNotEmpty((String)czPerson.getName()) && dto.getRealName().equals(czPerson.getName())) {
                    cz_BackgroundApproval.setApprovalreason("\u4e3b\u9879\u4fe1\u606f\u7b26\u5408");
                    cz_BackgroundApproval.setApprovalstate("003");
                    cz_BackgroundApproval.setRgapprovalstate("003");
                } else {
                    cz_BackgroundApproval.setApprovalreason("\u59d3\u540d\u4fe1\u606f\u6709\u8bef");
                    cz_BackgroundApproval.setApprovalstate("004");
                    cz_BackgroundApproval.setRgapprovalstate("004");
                }
            } else {
                cz_BackgroundApproval.setApprovalreason("\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728");
                cz_BackgroundApproval.setApprovalstate("004");
                cz_BackgroundApproval.setRgapprovalstate("004");
            }
            list.add(cz_BackgroundApproval);
            if (xdPerson != null) {
                xd_BackgroundApproval.setApprovalreason("\u5438\u6bd2\u4eba\u5458");
                xd_BackgroundApproval.setApprovalstate("004");
                xd_BackgroundApproval.setRgapprovalstate("004");
            } else {
                xd_BackgroundApproval.setApprovalreason("\u65e0\u5438\u6bd2\u8bb0\u5f55");
                xd_BackgroundApproval.setApprovalstate("003");
                xd_BackgroundApproval.setRgapprovalstate("003");
            }
            list.add(xd_BackgroundApproval);
            if (dtPerson != null) {
                dt_BackgroundApproval.setApprovalreason("\u5728\u9003\u4eba\u5458");
                dt_BackgroundApproval.setApprovalstate("004");
                dt_BackgroundApproval.setRgapprovalstate("004");
            } else {
                dt_BackgroundApproval.setApprovalreason("\u65e0\u5728\u9003\u8bb0\u5f55");
                dt_BackgroundApproval.setApprovalstate("003");
                dt_BackgroundApproval.setRgapprovalstate("003");
            }
            list.add(dt_BackgroundApproval);
            if (wfPerson != null) {
                wf_BackgroundApproval.setApprovalreason("\u6709\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55");
                wf_BackgroundApproval.setApprovalstate("004");
                wf_BackgroundApproval.setRgapprovalstate("004");
            } else {
                wf_BackgroundApproval.setApprovalreason("\u65e0\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55");
                wf_BackgroundApproval.setApprovalstate("003");
                wf_BackgroundApproval.setRgapprovalstate("003");
            }
            list.add(wf_BackgroundApproval);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (!"15".equals(dto.getBusinesstype()) && list != null && list.size() > 0) {
            this.backgroundApprovalDao.delete(dto);
            this.backgroundApprovalDao.batchSave(list);
        }
        return list;
    }

    public Map<String, PersonBaseInfo> getPersonInfo(String requestID, String serviceID, List<String> idnums, ResultType resultType, String DataObjectCode, String InfoCodeMode, String idType) {
        HashMap<String, PersonBaseInfo> personList = new HashMap<String, PersonBaseInfo>();
        String code = "";
        if (this.ZAFLAG != null && this.ZAFLAG.equals("1")) {
            for (int i = 0; i < 3; ++i) {
                String[] requiredItems = null;
                switch (resultType) {
                    case NAME: {
                        requiredItems = new String[]{idType, Constants.INFO_XM};
                        break;
                    }
                    case PHOTO: {
                        requiredItems = new String[]{idType, Constants.INFO_XM};
                        break;
                    }
                    case PERSON: {
                        requiredItems = new String[]{idType, Constants.INFO_XM, Constants.INFO_JGSSX, Constants.INFO_ZZ};
                        break;
                    }
                    default: {
                        requiredItems = new String[]{idType, Constants.INFO_XM, Constants.INFO_JGSSX, Constants.INFO_ZZ};
                    }
                }
                String requestResult = this.call(requestID, serviceID, idnums, requiredItems, Constants.NX_CZINFO_DataObjectCode, "002", idType);
                BjRestLog log = new BjRestLog();
                log.setResttype(serviceID);
                if (!resultType.equals((Object)ResultType.PHOTO) && !resultType.equals((Object)ResultType.ALL)) {
                    log.setResponseContext(requestResult);
                }
                log.setRequestContext(JSON.toJSONString(idnums));
                log.setCreateTime(new Date());
                log.setActive(Boolean.valueOf(true));
                log.setUpdateTime(new Date());
                log.setUpdateBy("system");
                this.bjRestLogDao.save(log);
                if (requestResult != null && !requestResult.equals("")) {
                    try {
                        String pattern = "\\s{2,}";
                        Pattern r = Pattern.compile(pattern);
                        Matcher m = r.matcher(requestResult);
                        requestResult = m.replaceAll("");
                        SAXReader reader = new SAXReader();
                        Document doc = reader.read((InputStream)new ByteArrayInputStream(requestResult.getBytes("UTF-8")));
                        Element root = doc.getRootElement();
                        Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                        if (valueElement != null) {
                            List list = valueElement.elements();
                            if (list != null && list.size() > 0) {
                                Element e = (Element)list.get(0);
                                code = e.element("Data").getText();
                            }
                            if (list != null && list.size() > 2) {
                                PersonBaseInfo person = null;
                                for (int j = 2; j < list.size(); ++j) {
                                    Element e = (Element)list.get(j);
                                    person = new PersonBaseInfo();
                                    switch (resultType) {
                                        case NAME: {
                                            this.getPersonName(person, e.content());
                                            break;
                                        }
                                        case PHOTO: {
                                            this.getPersonPhoto(person, e.content());
                                            break;
                                        }
                                        case PERSON: {
                                            this.getPerson(person, e.content());
                                            break;
                                        }
                                        default: {
                                            this.getAll(person, e.content());
                                        }
                                    }
                                    personList.put(person.getIdnum(), person);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u4eba\u53e3\u5e93\u83b7\u53d6\u5f02\u5e38\uff1a");
                        logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                }
                if (!"000".equals(code)) {
                    continue;
                }
                break;
            }
        } else {
            code = "000";
        }
        if (!"000".equals(code)) {
            throw new ArsException("\u5b81\u590f\u4eba\u53e3\u5e93\u8c03\u7528\u5f02\u5e38\uff01");
        }
        return personList;
    }

    private void getPersonName(PersonBaseInfo person, List contents) {
        person.setIdnum(((DefaultElement)contents.get(0)).getText());
        person.setName(((DefaultElement)contents.get(1)).getText());
    }

    private void getPersonPhoto(PersonBaseInfo person, List contents) {
        this.getPersonName(person, contents);
        person.setPhoto(this.getPhoto(person.getIdnum(), person.getName()));
    }

    private void getPerson(PersonBaseInfo person, List contents) {
        this.getPersonName(person, contents);
        String address = ((DefaultElement)contents.get(3)).getText();
        String areaAdd = this.sysareaService.findByCodeForFullName(((DefaultElement)contents.get(2)).getText());
        address = areaAdd + address.replace(areaAdd, "");
        person.setAddress(address);
    }

    private void getAll(PersonBaseInfo person, List contents) {
        this.getPerson(person, contents);
        person.setPhoto(this.getPhoto(person.getIdnum(), person.getName()));
    }

    private Map<String, PersonBaseInfo> getTest(ResultType resultType) {
        HashMap<String, PersonBaseInfo> personList = new HashMap<String, PersonBaseInfo>();
        String requestResult = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><RBSPMessage>    <Version/>    <ServiceID>S10-00000006</ServiceID>    <TimeStamp/>    <Validity/>    <Security>        <Signature Algorithm=\"\"/>        <CheckCode Algorithm=\"\"/>        <Encrypt/>    </Security>    <Method>        <Name>Query</Name>        <Items>            <Item>                <Value Type=\"arrayOfArrayOf_string\">                    <Row>                        <Data>000</Data>                    </Row>                    <Row>                        <Data>XM</Data>                    </Row>                </Value>            </Item>        </Items>    </Method></RBSPMessage>";
        String pattern = "\\s{2,}";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(requestResult);
        requestResult = m.replaceAll("");
        if (requestResult != null && !requestResult.equals("")) {
            try {
                SAXReader reader = new SAXReader();
                Document doc = reader.read((InputStream)new ByteArrayInputStream(requestResult.getBytes("UTF-8")));
                Element root = doc.getRootElement();
                Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                if (valueElement != null) {
                    List list = valueElement.elements();
                    if (list != null && list.size() > 0) {
                        Element element = (Element)list.get(0);
                    }
                    if (list != null && list.size() > 2) {
                        PersonBaseInfo person = null;
                        for (int j = 2; j < list.size(); ++j) {
                            Element e = (Element)list.get(j);
                            person = new PersonBaseInfo();
                            switch (resultType) {
                                case NAME: {
                                    this.getPersonName(person, e.content());
                                    break;
                                }
                                case PHOTO: {
                                    this.getPersonPhoto(person, e.content());
                                    break;
                                }
                                case PERSON: {
                                    this.getPerson(person, e.content());
                                    break;
                                }
                                default: {
                                    this.getAll(person, e.content());
                                }
                            }
                            personList.put(person.getIdnum(), person);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u4eba\u53e3\u5e93\u83b7\u53d6\u5f02\u5e38\uff1a");
                logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        return personList;
    }

    public static void main(String[] args) {
        NXSecurityInterfaceService securityInterfaceService = new NXSecurityInterfaceService();
        Map<String, PersonBaseInfo> personList = securityInterfaceService.getTest(ResultType.PERSON);
        System.out.println(JSON.toJSONString(personList));
    }

    public String getPhoto(String idNumber, String name) {
        String strResult = "";
        String code = "";
        int errorCount = 0;
        if (this.ZAFLAG != null && this.ZAFLAG.equals("1")) {
            for (int i = 0; i < 3; ++i) {
                block10: {
                    String result = this.call("C64-00000111", "S64-00000028", idNumber, new String[]{Constants.INFO_XP}, Constants.NX_CZPHOTO_DataObjectCode, "001", "GMSFHM");
                    BjRestLog log = new BjRestLog();
                    log.setResttype("S64-00000028");
                    log.setRequestContext(idNumber);
                    log.setCreateTime(new Date());
                    log.setActive(Boolean.valueOf(true));
                    log.setUpdateTime(new Date());
                    log.setUpdateBy("system");
                    this.bjRestLogDao.save(log);
                    if (StringUtil.isNotEmpty((String)result)) {
                        try {
                            SAXReader reader = new SAXReader();
                            Document doc = reader.read((InputStream)new ByteArrayInputStream(result.getBytes("UTF-8")));
                            Element root = doc.getRootElement();
                            Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                            if (valueElement != null) {
                                Element e;
                                List list = valueElement.elements();
                                if (list != null && list.size() > 0) {
                                    e = (Element)list.get(0);
                                    code = e.element("Data").getText();
                                }
                                if (list != null && list.size() > 2) {
                                    e = (Element)list.get(2);
                                    strResult = e.element("Data").getText();
                                }
                                break block10;
                            }
                            ++errorCount;
                        }
                        catch (Exception e) {
                            logger.error("\u8eab\u4efd\u8bc1\u53f7\uff1a" + idNumber);
                            logger.error("\u4eba\u53e3\u5e93\u83b7\u53d6\u5f02\u5e38\uff1a" + result);
                            logger.error(e.getMessage(), (Throwable)e);
                            ++errorCount;
                        }
                    } else {
                        logger.error("\u4eba\u53e3\u5e93\u83b7\u53d6\u5f02\u5e38,\u6ca1\u6709\u8fd4\u56de\u503c,\u8eab\u4efd\u8bc1\u53f7\uff1a" + idNumber);
                        ++errorCount;
                    }
                }
                if ("000".equals(code)) break;
            }
            if (errorCount == 3) {
                throw new ArsException("\u8c03\u7528\u516c\u5b89\u90e8\u63a5\u53e3\u5f02\u5e38\uff01\uff01");
            }
        }
        return strResult;
    }
}

