package com.bcxin.ars.dao;

import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.model.Module;
import com.bcxin.ars.model.Operation;
import com.bcxin.ars.model.Permission;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class PermissionDaoTest {

	@Autowired
	private ModuleDao moduleDao;
	
	@Autowired
	private OperationDao operationDao;
	
	@Autowired
	private PermissionDao permissionDao;
	
	@Test
	public void testModule() {
		List<Module> modules = moduleDao.findAll();
		Assert.assertTrue(modules.size() > 0);
		List<Operation> operations = modules.get(0).getOperationList();
		Assert.assertTrue(operations.size() > 0);
	}
	
	@Test
	public void testOperation() {
		Module module = new Module();
		module.setId(1l);
		List<Operation> operations = operationDao.findByModule(module);
		Assert.assertTrue(operations.size() > 0);
		Module m = operations.get(0).getModule();
		Assert.assertNotNull(m);
	}
	
	@Test
	public void testPermission() {
//		Role role = new Role();
//		role.setId(18l);
	//	List<Permission> list = permissionDao.findByRole(18l);
	//	Assert.assertTrue(list.size() > 0);
	}
	
}
