package com.abcxin.smart.core.persistence.dialect;

import com.abcxin.smart.core.persistence.IDialect;

/**
 * @author subinghui
 * @date 2017/1/13 16:48
 */
public class OracleDialect implements IDialect {
    @Override
    public String buildPaginationSql(String originalSql, int offset, int limit) {
        StringBuilder sql = new StringBuilder(originalSql);
        // ORACLE 分页是通过 ROWNUMBER 进行的， ROWNUMBER 是从 1 开始的
        offset++;
        sql.insert(0, "SELECT U.*, ROWNUM R FROM (").append(") U WHERE ROWNUM < ").append(offset + limit);
        sql.insert(0, "SELECT * FROM (").append(") TEMP WHERE R >= ").append(offset);
        return sql.toString();
    }
}
