package com.bcxin.ars.dao.supervision;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.supervision.CompanyPunish;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author yyx
 * @date 2020/06/15
 */
@Service
public class CompanyPunishDaoAop {
    @Autowired
    private  CompanyPunishDao  companyPunishDao;
    @DataChangeAnnotation(getEntityClazz = CompanyPunish.class,
            getDaoClazz = CompanyComplaintDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public int delete(CompanyPunish companyPunish) {
        return companyPunishDao.delete(companyPunish);
    }
    @DataChangeAnnotation(getEntityClazz = CompanyPunish.class,
            getDaoClazz = CompanyPunishDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void save(CompanyPunish companyPunish) {
        companyPunishDao.save(companyPunish);
    }

    @DataChangeAnnotation(getEntityClazz = CompanyPunish.class,
            getDaoClazz = CompanyPunishDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void saveBatch(List<CompanyPunish> list) {
        companyPunishDao.saveBatch(list);
    }
}
