package com.bcxin.ars.dao.subsidy;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.dao.sys.ImportConfigDao;
import com.bcxin.ars.dao.sys.ImportDao;
import com.bcxin.ars.dao.sys.SubsidyComparisonDao;
import com.bcxin.ars.dto.subsidy.ImportAopDto;
import com.bcxin.ars.model.sys.ImportConfig;
import com.bcxin.ars.model.sys.SubsidyComparison;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
/**
 * @author yyx
 * @date 2020/06/05
 */
/**
 * @author yyx
 * @date 2020/06/15
 */
@Service
public class ImportConfigDaoAop {
    @Autowired
    ImportConfigDao importConfigDao;
    @Autowired
    ImportDao importDao;
    @Autowired
    SubsidyComparisonDao subsidyComparisonDao;

    @DataChangeAnnotation(getEntityClazz = ImportConfig.class,
            getDaoClazz = ImportConfigDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void save(ImportConfig importConfig) {
        importConfigDao.save(importConfig);
    }
    @DataChangeAnnotation(getEntityClazz = SubsidyComparison.class,
            getDaoClazz = SubsidyComparisonDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void saveComparison(SubsidyComparison subsidyComparison) {
        subsidyComparisonDao.save(subsidyComparison);
    }
    @DataChangeAnnotation(getEntityClazz = ImportAopDto.class,
            getDaoClazz = ImportDao.class,
            getParamClazz = ImportAopDto.class,
            getParamType = ParamType.ENTITY,
            getFieldName ="idNum",
            getTableNameField = "tableName",
            getSearchMethodName = "findByKeyValueWithOutCache")
    public void updateListV1(ImportAopDto importAopDto) {
        importDao.updateListV1(importAopDto);
    }
}
