package com.bcxin.ars.dao.subsidy;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.sb.GradeSubsidyBatch;
import com.bcxin.ars.model.subsidy.GradeSubsidyRoster;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/06/03 0003 9:40
 */
@Service
public class GradeSubsidyRosterDaoAop {

    @Autowired
    private GradeSubsidyRosterDao gradeSubsidyRosterDao;


    @DataChangeAnnotation(getEntityClazz = GradeSubsidyRoster.class,
            getDaoClazz = GradeSubsidyRosterDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void save(GradeSubsidyRoster gradeSubsidyRoster) {
        gradeSubsidyRosterDao.save(gradeSubsidyRoster);
    }

    @DataChangeAnnotation(getEntityClazz = GradeSubsidyRoster.class,
            getDaoClazz = GradeSubsidyRosterDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateSelective(GradeSubsidyRoster gradeSubsidyRoster) {
        gradeSubsidyRosterDao.updateSelective(gradeSubsidyRoster);
    }

    @DataChangeAnnotation(getEntityClazz = GradeSubsidyRoster.class,
            getDaoClazz = GradeSubsidyRosterDao.class,
            getParamClazz = Long[].class,
            getParamType = ParamType.ENTITY,
            getSearchMethodName = "findByIdArrWithOutCache")
    public void updateBatchUsed(GradeSubsidyBatch gradeSubsidyBatch) {
        gradeSubsidyRosterDao.updateBatchUsed(gradeSubsidyBatch);
    }

    @DataChangeAnnotation(getEntityClazz = GradeSubsidyRoster.class,
            getDaoClazz = GradeSubsidyRosterDao.class,
            getParamClazz = Long.class,
            getParamType = ParamType.ENTITY,
            getSearchMethodName = "findBySubsidyBatchIdWithOutCache")
    public void updateUnUsedByBatchId(Long batchId) {
        gradeSubsidyRosterDao.updateUnUsedByBatchId(batchId);
    }

    @DataChangeAnnotation(getEntityClazz = GradeSubsidyRoster.class,
            getDaoClazz = GradeSubsidyRosterDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void saveBatch(List<GradeSubsidyRoster> rosterList) {
        gradeSubsidyRosterDao.saveBatch(rosterList);
    }
}
