package com.bcxin.ars.dao;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/06/10 0010 10:52
 */
@Service
public class UserDaoAop {

    @Autowired
    private UserDao userDao;

    @DataChangeAnnotation(getEntityClazz = User.class,
            getDaoClazz = UserDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void delete(User user){
        userDao.delete(user);
    }

    @DataChangeAnnotation(getEntityClazz = User.class,
            getDaoClazz = UserDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void update(User user){
        userDao.update(user);
    }

    @DataChangeAnnotation(getEntityClazz = User.class,
            getDaoClazz = UserDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updatePassword(User user){
        userDao.updatePassword(user);
    }

    @DataChangeAnnotation(getEntityClazz = User.class,
            getDaoClazz = UserDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateInitstep(User user){
        userDao.updateInitstep(user);
    }

    @DataChangeAnnotation(getEntityClazz = User.class,
            getDaoClazz = UserDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateXjdUserId(User user){
        userDao.updateXjdUserId(user);
    }

    public void updateLoginState(User user){
        userDao.updateLoginState(user);
    }

    @DataChangeAnnotation(getEntityClazz = User.class,
            getDaoClazz = UserDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateExportFlag(User user){
        userDao.updateExportFlag(user);
    }

    @DataChangeAnnotation(getEntityClazz = User.class,
            getDaoClazz = UserDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateFlag(User user){
        userDao.updateFlag(user);
    }

    @DataChangeAnnotation(getEntityClazz = User.class,
            getDaoClazz = UserDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateAuthMark(User user){
        userDao.updateAuthMark(user);
    }

    @DataChangeAnnotation(getEntityClazz = User.class,
            getDaoClazz = UserDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateConferenceState(User user){
        userDao.updateConferenceState(user);
    }

    @DataChangeAnnotation(getEntityClazz = User.class,
            getDaoClazz = UserDao.class,
            getParamClazz = List.class,
            getParamType = ParamType.ENTITY,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void saveBatch(List<User> list){
        userDao.saveBatch(list);
    }



}
