package com.bcxin.ars.dao.task;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.HotMap;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.TaskSearchDto;
import com.bcxin.ars.dto.UrgentTaskDTO;
import com.bcxin.ars.dto.report.TaskExecutionDto;
import com.bcxin.ars.dto.task.TaskDetailSearchDto;
import com.bcxin.ars.dto.task.TaskDto;
import com.bcxin.ars.model.task.Task;

/**
 * 任务数据类
 * @author Ethan
 */
public interface TaskDao {

	/**
	 * 任务搜索
	 * @param dto
	 * @return
	 */
	List<Task> search(TaskSearchDto dto);


	/**
	 * 任务搜索
	 * @param dto
	 * @return
	 */
	List<Task> searchForFeedback(TaskSearchDto dto);
	
	List<Task> searchForDataSynchronization(DataSynchronizationSearchDto dto);
	

	/**
	 * 任务搜索
	 * @param dto
	 * @return
	 */
	List<Task> searchForManage(TaskSearchDto dto);

	/**
	 * 任务数量搜索
	 * @param dto
	 * @return
	 */
	Long searchCount(TaskSearchDto dto);
	
	/**
	 * 任务数量搜索
	 * @param dto
	 * @return
	 */
	Long searchCountForManage(TaskSearchDto dto);
	
	/**
	 * 根据ID获取任务
	 * @param id
	 * @return
	 */
	Task findById(Long id);

	/**
	 * 根据ID获取saas任务
	 * @param id
	 * @return
	 */
	Task findSaasTaskById(Long id);
	/**
	 * 根据紧急任务查询详细信息
	 * @param id
	 * @return
	 */
	Task findUrgentById(Long id);



	/**
	 * 根据人员ID获取紧急任务列表
	 * @param dto 人员ID
	 * @return
	 */
	List<Task> findUrgentByPersnId(UrgentTaskDTO dto);
	
	/**
	 * 查询全部未完成且保安人员未到需要人数的紧急任务
	 * <b>Function </b> 
	 * 
	 * @return
	 * @author LinQingLin 
	 * @date 2017年6月14日 下午3:59:53
	 * @注意事项 </b>
	 * <b>
	 */
	List<Task> findForSendUrgentMsg();


	/**
	 * 根据用户ID和日期查询临近任务
	 * @param personId
	 * @param taskDate
	 * @param today
	 * @param minutes
	 * @return
	 */
	List<Task> findByPerson(Long personId, String taskDate, String today, Integer minutes);
	
	/**
	 * 
	 * <b>Function </b> 根据用户ID和接收状态查询任务
	 * 
	 * @return
	 * @注意事项 </b>
	 * <b>
	 */
	List<Task> findByPersonAcceptStatus(Long personId, Integer acceptStatus);
	
	/**
	 * 获取当天minustes内开始的任务记录
	 * @param statusId
	 * @param taskDate
	 * @param today
	 * @param minutes
	 * @return
	 */
	List<Task> findBefore(String taskDate, String today, Integer minutes);
	
	/**
	 * 获取当天minustes内结束的任务记录
	 * @param statusId
	 * @param taskDate
	 * @param today
	 * @param minutes
	 * @return
	 */
	List<Task> findEnd(String taskDate, String today, Integer minutes);
	
	/**
	 * 获取当天正在进行的任务记录
	 * @param taskDate
	 * @param today
	 * @return
	 */
	List<Task> findING(String taskDate, String today);
	
	/**
	 * 
	 * <b>Function </b> 根据用户ID,任务状态，分钟数查询
	 * 
	 * @param personId
	 * @param taskStatus
	 * @param minutes
	 * @return
	 * @author LinQingLin 
	 * @date 2017年3月9日 下午5:55:07
	 * @注意事项 </b>
	 * <b>
	 */
	List<Task> findTaskList(Long personId, Long taskStatus, Integer minutes);

	//List<Task> findTaskListByPersonid(Long personId);

	/**
	 * app任务列表查询
	 * @param taskSearchDto
	 * @return
	 */
	List<Task> findTaskListByPersonid(TaskSearchDto taskSearchDto);
	
	/**
	 * 批量更新任务状态
	 */
	void updateStatus();

	/**
	 * 新增任务
	 * @param task
	 * @return
	 */
	Long save(Task task);

	Long saveImport(Task task);
	
	/**
	 * 更新任务
	 * @param task
	 */
	void update(Task task);
	/**
	 * 更新任务
	 * @param id
	 * @param count
	 */
	void updateSendCount(Long id,Integer count);
	/**
	 * 删除任务
	 * @param task
	 * @return
	 */
	void delete(Task task);

	/**
	 * 任务区域画像
	 * @param dto
	 * @return
	 */
	List<ReportData> findAreaReport(TaskSearchDto dto);

	/**
	 * 任务种类画像
	 * @param dto
	 * @return
	 */
	List<ReportData> findCatalogReport(TaskSearchDto dto);

	/**
	 * 任务人员等级画像
	 * @param dto
	 * @return
	 */
	List<ReportData> findLevelReport(TaskSearchDto dto);

	/**
	 * 
	 * <b>Function </b> 任务id跟保安人员id查询任务详情
	 * 
	 * @param taskId
	 * @param personId
	 * @return
	 * @author LinQingLin 
	 * @date 2017年3月21日 下午5:53:27
	 * @注意事项 </b>
	 * <b>
	 */
	Task findDetailByIdPerson(Long taskId, Long personId);


	/**
	 * 查询紧急任务
	 * @author subh
	 * @return
	 */
	List<UrgentTaskDTO> findUrgentTask(UrgentTaskDTO dto);
	/**
	 * 统计查询紧急任务
	 * @author subh
	 * @return
	 */
	Long countUrgentTask(UrgentTaskDTO dto);

	/**
	 * 统计app任务列表
	 * @return
	 */
	Long countTaskListByPersonid(TaskSearchDto taskSearchDto);


	/***
	 * 获取人员当前的正在进行紧急任务
	 * @param personid
	 * @return
	 */
	List<Task> findAllByPersonId(Long personid);

	/**
	 * 获取公司热力
	 * @param companyid
	 * @return
	 */
	List<HotMap> findCompanyHot(Long companyid);
	/**
	 * 获取人员任务热力
	 * @param personid
	 * @return
	 */
	List<HotMap> findPersonHot(Long personid);

	/***
	 * 查询所有的紧急任务
	 * @return
	 */
	List<Task> findUrgentAll();

	Task findByRawId(Long rawid);

	Task findByInRawId(Long inrawid);

	List<Task> findEndTask();

	TaskDto findTaskDetail(TaskDetailSearchDto taskDetailDto);
	
	/**************************************V1.0.9APP版本****************************************************/
	/**
	 * app任务列表查询
	 * @param taskSearchDto
	 * @return
	 */
	List<Task> findTaskListByPersonid_V109(TaskSearchDto taskSearchDto);

	Long findTotalByCompanyId(Long companyId);

	Long findCycleCountByCompanyId(Long companyId);

	Long findTemporaryCountByCompanyId(Long companyId);
	
	Long findUrgentCountByCompanyId(Long companyId);
	
	TaskDto findTaskDetail_V109(TaskDetailSearchDto taskDetailDto);
	TaskExecutionDto findTaskExecutionReport(Long companyId);
	/**
	 * 统计app任务列表
	 * @return
	 */
	Long countTaskListByPersonid_V109(TaskSearchDto taskSearchDto);
}
