package com.bcxin.ars.dao.task;

import java.util.List;

import com.bcxin.ars.model.task.TaskCatalog;

/**
 * 任务种类数据类
 * @author Ethan
 */
public interface TaskCatalogDao {

	/**
	 * 获取全部任务种类
	 * @return
	 */
	List<TaskCatalog> find();
	
	/**
	 * 根据父ID获取子分类
	 * @param parentId
	 * @return
	 */
	List<TaskCatalog> findByParentId(Long parentId);
	
	/**
	 * 根据ID获取任务种类
	 * @return
	 */
	TaskCatalog findById(Long id);
	
}
