package com.bcxin.ars.dao.task;

import java.util.List;

import com.bcxin.ars.dto.page.ComTempTaskPerPageSearchDto;
import com.bcxin.ars.model.task.ComTempTask;
import com.bcxin.ars.model.task.ComTempTaskPer;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

/**
 * 临保任务人员Dao接口
 * 
 * @author lin
 * @date 2021-02-01
 */
public interface ComTempTaskPerDao{

    /****
     * 删除
     * @param comTempTaskPer
     * @return
     */
    int delete(ComTempTaskPer comTempTaskPer);

    /****
     * 保存
     * @param comTempTaskPer
     * @return
     */
    int save(ComTempTaskPer comTempTaskPer);

    /****
     * 主键查询
     * @param id
     * @return
     */
     ComTempTaskPer findById(Long id);

    /****
     * 选择修改
     * @param comTempTaskPer
     * @return
     */
    int updateSelective(ComTempTaskPer comTempTaskPer);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<ComTempTaskPer> searchForPage(ComTempTaskPerPageSearchDto searchDto, AjaxPageResponse<ComTempTaskPer> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<ComTempTaskPer> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<ComTempTaskPer> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<ComTempTaskPer> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ComTempTaskPer> findByBatchId(@Param("list") List<ComTempTaskPer> list);


    List<ComTempTaskPer> findByComTempTask(ComTempTask comTempTask);
}
