package com.bcxin.ars.dao.task;

import java.util.List;

import com.bcxin.ars.dto.page.ComTempTaskPageSearchDto;
import com.bcxin.ars.dto.task.ComTempTaskDto;
import com.bcxin.ars.model.task.ComTempTask;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

/**
 * 临保任务Dao接口
 * 
 * @author lin
 * @date 2021-02-01
 */
public interface ComTempTaskDao{

    /****
     * 删除
     * @param comTempTask
     * @return
     */
    int delete(ComTempTask comTempTask);

    /****
     * 保存
     * @param comTempTask
     * @return
     */
    int save(ComTempTask comTempTask);

    /****
     * 主键查询
     * @param id
     * @return
     */
     ComTempTask findById(Long id);

    /****
     * 选择修改
     * @param comTempTask
     * @return
     */
    int updateSelective(ComTempTask comTempTask);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<ComTempTaskDto> searchForPage(ComTempTaskPageSearchDto searchDto, AjaxPageResponse<ComTempTaskDto> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<ComTempTask> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<ComTempTask> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<ComTempTask> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ComTempTask> findByBatchId(@Param("list") List<ComTempTask> list);


    /**
     * 定时变更任务状态
     */
    void updateStartTaskStatus();
}
