package com.bcxin.ars.dao.task;

import com.bcxin.ars.dto.page.task.ComTaskSearchDto;
import com.bcxin.ars.dto.task.ComTaskDto;
import com.bcxin.ars.model.task.ComContract;
import com.bcxin.ars.model.task.ComTask;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;

import java.util.List;

/**
 * 驻勤点dao接口
 */
public interface ComTaskDao {

    /**
     * 保存
     * @param record
     */
    void save(ComTask record);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list")List<ComTask> list);

    /**
     * 根据id查询
     * @param comTaskId
     * @return
     */
    ComTask findById(Long comTaskId);
    ComTask findByIdWithOutCache(Long comTaskId);

    /**
     * 根据id查询 给页面展示
     * @param comTaskId
     * @return
     */
    ComTaskDto findDetailById(Long comTaskId);

    /**
     * 根据id集合批量查询
     * @param list
     * @return
     */
    List<ComTask> findByBatchId(@Param("list")List<ComTask> list);

    List<ComTask> findByBatchIdWithOutCache(@Param("list")List<ComTask> list);
    /**
     * 根据人员获取驻勤点信息
     * @param perId
     * @return
     */
    List<ComTask> findByPerId(Long perId);
    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    List<ComTaskDto> search(ComTaskSearchDto dto, AjaxPageResponse<ComTaskDto> page);

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    List<ComTaskDto> searchV3(ComTaskSearchDto dto, AjaxPageResponse<ComTaskDto> page);

    int searchV3Count(ComTaskSearchDto dto);

    List<ComTaskDto> searchV2(ComTaskSearchDto dto, AjaxPageResponse<ComTaskDto> page);

    /**
     * 外导内数据查询
     * @param dto
     * @return
     */
    List<ComTask> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    List<ComTask> findByContractId(String contractId);


    void removeRelationTask(ComTask comTask);

    void relationTask(ComTask comTask);

    void updateStartTaskStatus();

    List<ComTask> findEndTaskList();

    void endTaskStatus(@Param("list")List<ComTask> taskList);

    void removeRelationTaskList(@Param("list")List<ComTask> taskList);

    void deleteByContractId(@Param("comContractId") Long comContractId);

    void deleteBatchByContractIds(@Param("list")List<ComContract> list);

    /**
     * 定时器更新驻勤状态和合同状态
     */
    void updateTaskStatusNew(@Param("comTaskId") Long comTaskId);

    /**
     * 定时器更新合同状态
     */
    void updateContractStatus();

    void delete(ComTask comTask);

    void deleteBatch(@Param("list") List<ComTask> taskList);

    /**
     * 根据公司ID获取有资格的驻勤点
     * @param comId
     * @return
     */
    List<ComTask> findByComId(String comId);

}