package com.bcxin.ars.dao.task;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.task.ComShift;
import com.bcxin.ars.dto.page.task.ComShiftPageSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *企业班次Dao
 * @author linqinglin
 * @Date 2020-03-26 09:39:32
 */
public interface ComShiftDao {

   /****
     * 删除
     * @param comShift
     * @return
     */
    int delete(ComShift comShift);

    /****
     * 保存
     * @param comShift
     * @return
     */
    int save(ComShift comShift);

    /****
     * 新增
     * @param comShift
     * @return
     */
    int insert(ComShift comShift);

    /****
     * 选择性插入
     * @param comShift
     * @return
     */
    int insertSelective(ComShift comShift);

    /****
     * 主键查询
     * @param shiftId
     * @return
     */
    ComShift findById(Long shiftId);

    /****
     * 修改
     * @param comShift
     * @return
     */
    int update(ComShift comShift);

    /****
     * 选择修改
     * @param comShift
     * @return
     */
    int updateSelective(ComShift comShift);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<ComShift> searchForPage(ComShiftPageSearchDto searchDto, AjaxPageResponse<ComShift> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<ComShift> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<ComShift> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<ComShift> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ComShift> findByBatchId(@Param("list") List<ComShift> list);
}
