package com.bcxin.ars.dao.task;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.task.ComContractSearchDto;
import com.bcxin.ars.dto.task.ComContractDto;
import com.bcxin.ars.model.task.ComContract;
import com.bcxin.ars.model.task.ComContractStation;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 合同dao接口
 */
public interface ComContractDao {

    /**
     * 保存
     * @param record
     */
    void save(ComContract record);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list")List<ComContract> list);
    /**
     * 根据id查询
     * @param comContractId
     * @return
     */
    ComContract findById(Long comContractId);

    /**
     * 根据id集合批量查询
     * @param list
     * @return
     */
    List<ComContract> findByBatchIds(@Param("list")List<ComContract> list);

    /**
     * 分页查询
     * @param dto
     * @return
     */
    List<ComContractSearchDto> search(ComContractSearchDto dto);


    /**
     * 分页统计
     * @param dto
     * @return
     */
    Long searchCount(ComContractSearchDto dto);
    /**
     * 外导内数据查询
     * @param dto
     * @return
     */
    List<ComContract> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    void endContractStatus();

    /**
     * 根据人员id获取劳动合同
     * @param perId
     * @return
     */
    List<ComContract> findByPerId(Long perId);
    /**
     * 根据人员id获取有效的劳动合同
     * @param perId
     * @return
     */
    ComContract findValidByPerId(Long perId);

    ComContractDto findDetailById(Long id);
    /**
     * 查询要附件转换的合同信息
     * @return
     */
    List<ComContract> findConverImg();
    /**
     * 更新地址转换
     * @param record
     */
    void updateUrl(ComContract record);
}