package com.bcxin.ars.dao.sys;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.sys.MinisterialLog;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 数据上报部级接口记录Dao接口
 * 
 * @author linqinglin
 * @date 2021-03-04
 */
public interface MinisterialLogDao{

    /****
     * 删除
     * @param ministerialLog
     * @return
     */
    int delete(MinisterialLog ministerialLog);

    /****
     * 保存
     * @param ministerialLog
     * @return
     */
    int save(MinisterialLog ministerialLog);

    /****
     * 主键查询
     * @param id
     * @return
     */
     MinisterialLog findById(Long id);

    /****
     * 选择修改
     * @param ministerialLog
     * @return
     */
    int updateSelective(MinisterialLog ministerialLog);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<MinisterialLog> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<MinisterialLog> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<MinisterialLog> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<MinisterialLog> findByBatchId(@Param("list") List<MinisterialLog> list);

    /**
     * 查询
     * @param ministerialLog
     * @return
     */
    MinisterialLog find(MinisterialLog ministerialLog);


    List<Map> findByType(Map paramMap);

    List<Map> findByParam(Map paramMap);

    void saveByType(@Param("log") MinisterialLog ministerialLog, @Param("list") List subList);
}
