package com.bcxin.ars.dao.sys;

import com.bcxin.ars.dto.sys.ExportConfigDto;
import com.bcxin.ars.model.sys.ExportConfig;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/***
 * 导出配置数据层
 */
public interface ExportConfigDao {
    /**
     * 根据id查询
     * @param id
     * @return
     */
    ExportConfig findById(Long id);
    /**
     * 分页查询
     * @param exportConfigDto
     * @param page
     */
    List<ExportConfig> search(ExportConfigDto exportConfigDto, AjaxPageResponse<ExportConfig> page);
    /***
     * 保存
     * @param subsidyConfig
     */
    void save(ExportConfig subsidyConfig);

    /**
     * 根据花名册导出类型查询标题
     * @param exportType
     * @return
     */
    ExportConfig selectByExportType(String exportType);
}
