package com.bcxin.ars.dao.sys;

import com.bcxin.ars.dto.ApprovalDTO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.page.ApprovalOutTimePageSearchDto;
import com.bcxin.ars.dto.page.ApprovalPageSearchDto;
import com.bcxin.ars.dto.sys.ApprovalFormDto;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sb.Yearreportdata;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * Created by 苏 on 2017/5/1.
 */
public interface ApprovalDAO {
    //查询保全list数据
    List<Map<Object, Object>> queryApprovalList(Map<Object, Object> p);

    int queryAllCnt(Map<Object, Object> p);

    int queryAll(Map<Object, Object> p);

    int queryWeekNewAddCnt(Map<Object, Object> p);

    int queryMonthsNewAddCnt(Map<Object, Object> p);

    int queryYearNewAddCnt(Map<Object, Object> p);

    /**
     * @return java.util.List<com.bcxin.ars.model.sys.Approval>
     * @Decription:通过id批量查询
     * @author：zhongjianhui
     * @method batchFindApprovalBypersonId
     * @date：2019/1/28 17:18
     * @params： * @param personIds
     */
    List<Approval> batchFindApprovalBypersonId(@Param("personIds") Long[] personIds);

    /**
     * 查询审批信息
     *
     * @param dto
     * @return
     */
    List<Approval> search(ApprovalDTO dto);

    /**
     * 查询审批信息
     *
     * @param dto
     * @return
     */
    List<Approval> searchForExport(ApprovalDTO dto);

    /***
     * 统计审批信息条数
     * @param dto
     * @return
     */
    Long searchCount(ApprovalDTO dto);

    /***
     * 根据主键获取
     * @param id
     * @return
     */
    Approval getById(Long id);

    /***
     * 根据主键获取
     * @param approvalList
     * @return
     */
    List<Approval> getByBatchId(@Param("approvalList") List<Approval> approvalList);

    /***
     * 根据id查询
     * @param id
     * @return
     */
    Map findByApprovalId(Long id);

    /**
     * @return java.util.List<com.bcxin.ars.model.sys.Approval>
     * @Decription:通过id查询可以审批的保安人员
     * @author：zhongjianhui
     * @method batchBayzApprovalFindByID
     * @date：2019/1/3 14:14
     * @params： * @param personIds
     */
    List<Approval> batchBayzApprovalFindByID(Long[] personIds);

    /***
     * 保存审批信息
     */
    void save(Approval approval);

    /***
     * 更新
     * @param approval
     */
    void update(Approval approval);

    /***
     * 批量更新
     * @param approvallist
     */
    void updatebatch(@Param("approvalList") List<Approval> approvalList);

    /***
     * 根据业务类型和业务ID查询
     * @param dto
     * @return
     */
    List getBusinessidAndType(ApprovalDTO dto);

    /***
     * 根据id删除
     * @param id
     */
    void deleteById(Long id);

    /**
     * 查询变更记录for数据同步
     */
    List<Approval> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /***
     * 保存审批信息 for数据同步
     */
    void saveForDS(Approval approval);


    Approval findBybusinessid(Long businessid);

    Approval findBybusinessidAndType(Long businessid, String businesstype);

    @Deprecated
    Approval findBybusinessidAndUserId(Long userid, String businesstype);

    Long findCountByUserId(Long userId);

    List<ReportData> getTypeGroupByUserId(Long userId);

    int countApprovalList(Map<Object, Object> p);

    List<Map<Object, Object>> searchApprovalList(Map<Object, Object> p);

    int countApprovalList_new(Map<Object, Object> p);

    /***
     * 统计审批超时3天
     * @param p
     * @return
     */
    int countTimeOutDays(Map<Object, Object> p);


    List<Map<Object, Object>> searchApprovalList_new(Map<Object, Object> p);

    /**
     * 更新新增修改标志
     *
     * @param approval
     */
    void updateFlag(Approval approval);

    /**
     * 内导外数据
     *
     * @param startDate 开始时间
     * @return
     */
    List<Approval> searchUpdateflagForExport(String startDate);

    String getMaxSerialNo(Approval approval);

    ApprovalFormDto findFormDataByApproval(Approval approval);

    /**
     * @Author: wangcy
     * @Description:查询申请相关信息总条数
     * @Date: 2018/01/18 0018 17:20
     */
    int countApprovalAndSBList(Map<Object, Object> p);

    /**
     * @Author: wangcy
     * @Description:查询申请相关信息集合
     * @Date: 2018/01/18 0018 17:20
     */
    List<Map<Object, Object>> searchApprovalAndSBList(Map<Object, Object> p);

    Approval findByYearReport(Yearreportdata yearreport);

    void updateBusinessApprovalState(Approval approval);

    void deleteByBusinessId(Long businessid, String businesstype);


    /**
     * @return void
     * @Decription:批量修改审批状态
     * @author：subh
     * @method batchSaveConfirmOrder
     * @date：2018/12/13 13:49
     * @params： personIds 人员记录ID列表
     */
    void batchUpdateApprovalState(@Param("approvalState") String approvalState, @Param("personIds") Long[] personIds);

    /**
     * 查询未启动流程审批记录
     *
     * @return
     */
    List<Approval> findUnStartProcess();

    /***
     * 查询超时未审批记录
     * @param dto 查询条件参数
     * @param ajaxPageResponse 返回数据对象
     * @return 查询列表
     */
    List<Approval> searchForOutTimeApproval(ApprovalOutTimePageSearchDto dto, AjaxPageResponse<Approval> ajaxPageResponse);

    /**
     * 待审批 分页查询
     *
     * @param searchDto
     * @return
     */
    List<Approval> searchForPage(ApprovalPageSearchDto searchDto);

    Long searchForPage_count(ApprovalPageSearchDto searchDto);

    Approval findByProcessInstanceId(String processInstanceId);

    void updatePersoncertificateStatus(Personcertificate personcertificate);

    void updateServiceCode(Approval approval);

    Integer searchApprovalForPageCount(Map<Object, Object> p);

    List<Map<Object, Object>> searchApprovalForPage(Map<Object, Object> p);

    List<Approval> findUnPushToAppraise();

    /**
     * 查询已审批记录 分页
     *
     * @param dto
     * @param page
     * @return
     */
    List<Approval> searchDoneForPage(ApprovalPageSearchDto dto, AjaxPageResponse<Approval> page);

    Approval findByRecordNo(String recordNo);
    Approval findApproval(String businessid);
}
