package com.bcxin.ars.dao.subsidy;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.GradeSubsidyBatchDto;
import com.bcxin.ars.dto.subsidy.GradeSubsidyRosterDto;
import com.bcxin.ars.dto.subsidy.GradeSubsidyRosterSearchDto;
import com.bcxin.ars.dto.subsidy.ImportAopDto;
import com.bcxin.ars.model.sb.GradeSubsidyBatch;
import com.bcxin.ars.model.subsidy.GradeSubsidyRoster;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface GradeSubsidyRosterDao {
    /**
     * 根据id查询
     * @param id
     * @return
     */
    GradeSubsidyRoster findById(Long id);

    GradeSubsidyRoster findByIdWithOutCache(Long id);
    /**
     * 分页查询
     * @param gradeSubsidyRosterSearchDto
     * @param page
     */
    List<GradeSubsidyRoster> search(GradeSubsidyRosterSearchDto searchDto, AjaxPageResponse<GradeSubsidyRoster> page);
    /***
     * 保存
     * @param gradeSubsidyRoster
     */
    void save(GradeSubsidyRoster gradeSubsidyRoster);

    /**
     * 批量保存
     * @param rosterList
     */
    void saveBatch(List<GradeSubsidyRoster> rosterList);

    /**
     * 批量修改为使用中
     * @param rosterIds
     */
    void updateBatchUsed(GradeSubsidyBatch gradeSubsidyBatch);

    /**
     * 选择修改
     * @param roster
     */
    void updateSelective(GradeSubsidyRoster roster);

    /**
     * 根据批次id修改为未使用
     * @param batchId
     */
    void updateUnUsedByBatchId(@Param("batchId") Long batchId);

    /**
     * 根据线下审批单id修改为未使用
     * @param offId
     */
    void updateUnUsedByOffId(@Param("offId") Long offId);
    /**
     * 根据身份证号批量查询
     * @param list
     * @return
     */
    List<Map<String, String>> selectByIdNum(List<Map<String, String>> list);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<GradeSubsidyRoster> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<GradeSubsidyRoster> findDSOutList(String startDate);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<GradeSubsidyRoster> findByBatchId(@Param("list")List<GradeSubsidyRoster> list);

    List<GradeSubsidyRoster> findByBatchIdWithOutCache(@Param("list")List<GradeSubsidyRoster> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<GradeSubsidyRoster> findByIdArrWithOutCache(GradeSubsidyBatch gradeSubsidyBatch);

    /**
     * 根据报名id查询
     * @param gradeId
     * @return
     */
    GradeSubsidyRoster findByGradeId(Long gradeId);

    List<GradeSubsidyRoster> findBySubsidyBatchId(Long subsidyBatchId);

    List<GradeSubsidyRoster> findBySubsidyBatchIdWithOutCache(Long subsidyBatchId);

    List<GradeSubsidyRoster> findBySubsidyBatchIds(@Param("list") List<GradeSubsidyBatch> list);

    GradeSubsidyRoster findByIdNumAndType(@Param("idNum") String idNum, @Param("subsidyCerType") String subsidyCerType);

    List<GradeSubsidyRoster> searchForApply(GradeSubsidyRosterSearchDto searchDto, AjaxPageResponse<GradeSubsidyRosterDto> page);

    Map statistics(GradeSubsidyRosterSearchDto searchDto);

    List<GradeSubsidyRoster> findByImportConfig(ImportAopDto importAopDto);

    void updateBatchUsedState(@Param("batchId") String batchId, @Param("idArr") Long[] idArr);

    /**
     * 人员补贴申请状态接口查询
     *
     * @param subsidyRoster 人员信息
     * @return 申请状态
     */
    GradeSubsidyRoster findSubsidyStatusAndSubsidyMoney(GradeSubsidyRoster subsidyRoster);

    /**
     * 根据身份证集合和补贴类型查询花名册
     *
     * @param gradeSubsidyBatchDto 身份证集合 补贴类型
     * @return 花名册信息
     */
    List<GradeSubsidyRoster> findByIdNumbersAndType(GradeSubsidyBatchDto gradeSubsidyBatchDto);
}

