package com.bcxin.ars.dao.sb;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.VehicleSearchDto;
import com.bcxin.ars.model.sb.Vehicle;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

public interface VehicleDao {

	Vehicle findById(long id);
	
	Long save(Vehicle vehicle);
	
	void update(Vehicle vehicle);
	
	List<Vehicle> search(VehicleSearchDto dto);
	
	Long searchCount(VehicleSearchDto dto);

	void delete(Vehicle vehicle);

	List<Vehicle> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveForDS(Vehicle vehicle);

	/***
	 * 查询全部车辆信息
	 * @param
	 * @return
	 */
	List<Vehicle> findAll();


    List<Vehicle> searchForPage(VehicleSearchDto searchDto, AjaxPageResponse<Vehicle> page);
}
