package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.TrainChangeSearchDto;
import com.bcxin.ars.model.sb.TrainChange;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * Created by 苏 on 2017/5/19.
 */
public interface TrainChangeDao {

    TrainChange findById(Long id);

    TrainChange findByIdWithOutCache(Long id);
    /**
     *
     * @Decription:批量查询
     * @author：zhongjianhui
     * @method  findByBatchId
     * @date：2018/8/17 9:17
     * @params： * @param approvalList
     * @return java.util.List<com.bcxin.ars.model.sb.Crosscompany>
     */
    List<TrainChange> findByBatchId(@Param("approvalList") List<Approval> approvalList);

    List<TrainChange> findByBatchIdWithOutCache(@Param("approvalList") List<Approval> approvalList);

    /**
     *
     * @Decription:通过id查询处理签打印内容
     * @author：zhongjianhui
     * @method  searchForPrintf
     * @date：2018/10/12 17:08
     * @params： * @param id
     * @return java.util.Map
     */
    Map searchForPrintf(long id);
    /**
     *
     * @Decription:批量更新
     * @author：zhongjianhui
     * @method  updateBatch
     * @date：2018/8/17 9:20
     * @params： * @param approvalList
     * @return void
     */
    void updateBatch(@Param("approvalList") List<TrainChange> approvalList);

    Long save(TrainChange trainChange);

    void update(TrainChange trainChange);

    List<TrainChange> search(TrainChangeSearchDto dto);


    /***
     * 项目变更证书查询
     * @param dto
     * @return
     */
    List<TrainChange> searchCompanyCertificate(TrainChangeSearchDto dto);
    /***
     * 项目变更证书查询（个数）
     * @param dto
     * @return
     */
    Long searchCompanyCertificateCount(TrainChangeSearchDto dto);

    Long searchCount(TrainChangeSearchDto dto);

    void delete(TrainChange trainChange);

    TrainChange findByUser(Long userid);

    List<TrainChange> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	List<TrainChange> findAll();

    int countTrainChangeList(Map<Object, Object> p);

    List<Map<Object,Object>> searchTrainChangeList(Map<Object, Object> p);

    List<TrainChange> findApproveByUserId(Long userId);

    List<TrainChange> findApprovePassByCompanyId(Long companyId);

    List<Map<Object,Object>> searchForPage(TrainChangeSearchDto dto, AjaxPageResponse<TrainChange> page);
}
