package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.dto.sb.SponsorlicenseSearchDto;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface SponsorlicenseDao {
	/**
	 *
	 * @Decription:通过id查询处理签打印内容
	 * @author：zhongjianhui
	 * @method  searchForPrintf
	 * @date：2018/10/12 17:08
	 * @params： * @param id
	 * @return java.util.Map
	 */
	Map searchForPrintf(long id);

	Sponsorlicense findById(Long id);

	Sponsorlicense findByIdWithOutCache(Long id);
	/**
	 *
	 * @Decription:批量查询
	 * @author：zhongjianhui
	 * @method  findByBatchId
	 * @date：2018/8/16 10:16
	 * @params： * @param approvalList
	 * @return com.bcxin.ars.model.sb.Sponsorlicense
	 */
	List<Sponsorlicense> findByBatchId(@Param("approvalList") List<Approval> approvalList);

	List<Sponsorlicense> findByBatchIdWithOutCache(@Param("approvalList") List<Approval> approvalList);

	Long save(Sponsorlicense sponsorlicense);

	void update(Sponsorlicense sponsorlicense);

	void updateBatch(@Param("approvalList")List<Sponsorlicense> approvalList);
	
	List<Sponsorlicense> search(SponsorlicenseSearchDto dto);
	
	Long searchCount(SponsorlicenseSearchDto dto);

	Sponsorlicense findByUser(Long userid);

    List<Sponsorlicense> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void updateCensorStatus(Sponsorlicense sponsorlicense);

	List<Sponsorlicense> findAll();

	List<ReportData> findByAreaReport(ReportDataSearchDto searchDto);

	int countSponsorlicenseList(Map<Object, Object> p);

	List<Map<Object,Object>> searchSponsorlicenseList(Map<Object, Object> p);

    Sponsorlicense findApproveByCompanyName(String companyname);

	List<Map<String, Object>> find();

	int findExistsSecurityGuard(@Param("idNumber")String idNumber);


    /***
     * 根据状态查询数据
     * @return
     */
    List<Sponsorlicense> findForSX();

	List<Map<String, Object>> searchForPage(SponsorlicenseSearchDto dto, AjaxPageResponse<Sponsorlicense> page);

	List<Sponsorlicense> findUnIntegrated();
}
