package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.SecAssociationRatingPageSearchDto;
import com.bcxin.ars.model.sb.SecAssociationRating;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 保安协会等级评定Dao接口
 * 
 * @author lin
 * @date 2021-04-20
 */
public interface SecAssociationRatingDao{

    /****
     * 删除
     * @param secAssociationRating
     * @return
     */
    int delete(SecAssociationRating secAssociationRating);

    /****
     * 保存
     * @param secAssociationRating
     * @return
     */
    int save(SecAssociationRating secAssociationRating);

    /****
     * 主键查询
     * @param id
     * @return
     */
     SecAssociationRating findById(Long id);

    /****
     * 选择修改
     * @param secAssociationRating
     * @return
     */
    int updateSelective(SecAssociationRating secAssociationRating);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<SecAssociationRating> searchForPage(SecAssociationRatingPageSearchDto searchDto, AjaxPageResponse<SecAssociationRating> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<SecAssociationRating> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<SecAssociationRating> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<SecAssociationRating> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<SecAssociationRating> findByBatchId(@Param("list") List<SecAssociationRating> list);


    /**
     * 根据公司名称查询受理中或者已受理的
     * @param comName
     * @return
     */
    SecAssociationRating findByComName(String comName);

    /**
     * 根据公司名称查询受理中或者已受理的
     * @param userId
     * @return
     */
    SecAssociationRating findByUserId(Long userId);
}
