package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.SecurityPersonSearchRerurnDTO;
import com.bcxin.ars.dto.ZTree;
import com.bcxin.ars.dto.certificate.GradeAndCertificateDto;
import com.bcxin.ars.dto.page.PerconUnRegDto;
import com.bcxin.ars.dto.page.PersonPageSearchDto;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.dto.sb.*;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.exam.TrainExamPerson;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.model.sb.VPersoncertificate;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * Created by 苏 on 2017/5/19.
 */
public interface PersoncertificateDao {

	/**
	 * 保安员资格证考试报名数据统计列表数量 param p by llc 2018-08-24
	 */
	int statisCertificateCount(Map<Object, Object> p);

	/**
	 * 保安员资格证考试报名数据统计列表 param p by llc 2018-08-24
	 */
	List<Map<Object, Object>> statisCertificateList(Map<Object, Object> p);


	/**
	 * 保安员资格证考试报名数据统计数量
	 * 
	 * @param p
	 * @return by llc 2018-08-23
	 */

	Map<String, Object> statisCertificate(Map<Object, Object> p);

	Personcertificate findById(Long id);

	Personcertificate findByIdWithOutCache(Long id);

	/**
	 *
	 * @Decription:通过id批量查询
	 * @author：zhongjianhui
	 * @method findByBatchId @date：2018/8/16 17:52 @params： * @param
	 *         approvalList
	 * @return java.util.List<com.bcxin.ars.model.sb.Personcertificate>
	 */
	List<Personcertificate> findByBatchPersonId(
			@Param("personcertificateList") List<Personcertificate> personcertificateList);

	/**
	 *
	 * @Decription:通过id批量查询
	 * @author：zhongjianhui
	 * @method findByBatchId @date：2018/8/16 17:52 @params： * @param
	 *         approvalList
	 * @return java.util.List<com.bcxin.ars.model.sb.Personcertificate>
	 */
	List<Personcertificate> findFeeStateByBatchPersonId(
			@Param("personcertificateList") List<SecurityPersonSearchRerurnDTO> personcertificateList);

	/**
	 *
	 * @Decription:通过bussinessID批量查询
	 * @author：zhongjianhui
	 * @method findByBatchId @date：2018/8/16 17:52 @params： * @param
	 *         approvalList
	 * @return java.util.List<com.bcxin.ars.model.sb.Personcertificate>
	 */
	List<Personcertificate> findByApprovalBatchId(@Param("approvalList") List<Approval> approvalList);

	/**
	 *
	 * @Decription:批量更新
	 * @author：zhongjianhui
	 * @method findByBatchId @date：2018/8/16 17:52 @params： * @param
	 *         approvalList
	 * @return java.util.List<com.bcxin.ars.model.sb.Personcertificate>
	 */
	void updateBatch(@Param("list") List<Personcertificate> list);

    /**
     * 选择更新
     * @param personcertificate
     */
	void updateSelective(Personcertificate personcertificate);

	Personcertificate findByPersonid(Personcertificate personcertificate);

	Long save(Personcertificate personcertificate);

	void update(Personcertificate personcertificate);

	List<Personcertificate> search(PersoncertificateSearchDto dto);

	List<Personcertificate> searchExport(PersoncertificateSearchDto dto);

	List<Personcertificate> findNofinger();

	Long searchCount(PersoncertificateSearchDto dto);

	void delete(Personcertificate personcertificate);

	Personcertificate findByUser(Long userid);

	List<Personcertificate> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);
	/**
	 *
	 * @Decription:确认所选择的人员哪些不可制证
	 * @author：zhongjianhui
	 * @method  checkConfirmOrder
	 * @date：2018/12/13 13:44
	 * @params： * @param personIds
	 * @return java.util.List<java.util.Map>
	 */
	List<Map> checkConfirmOrder(Long[] personIds);
	/**
	 *
	 * @Decription:批量修改制证状态
	 * @author：zhongjianhui
	 * @method  batchSaveConfirmOrder
	 * @date：2018/12/13 13:49
	 * @params： * @param personIds
	 * @param username
	 * @return void
	 */
	void batchSaveConfirmOrder(@Param("personIds")Long[] personIds,@Param("username")String username);

	/**
	 * 根据身份证返回制证状态
	 *
	 * @param cardnumber
	 * @return
	 */
	Personcertificate getCardStateByCardnumber(String cardnumber);

	/**
	 * 通过idList查询保安员资格证考试信息
	 *
	 * @param paramList
	 * @return by llc 2018-06-19
	 */
	List<Personcertificate> getPersoncertificateListByParamList(List<Map<String, String>> paramList);

	/**
	 * 根据身份证,科目ID返回制证状态
	 *
	 * @param personcertificate
	 * @return
	 */
	Personcertificate getCardState(Personcertificate personcertificate);

	/**
	 * 百课堂身份证号更新缴费状态
	 *
	 * @param personcertificateList
	 */
	@Deprecated
	int updateBktfeeStateByBatchID(List<SecurityPersonSearchRerurnDTO> personcertificateList);

	List<ExamDto> findUnScheduledPersonList(ExamSearchDto searchDto);

	Long searchUnScheduledCount(ExamSearchDto searchDto);

	Personcertificate findByIdNum(String idNum);

	List<Personcertificate> findAll();

    /**
     * 内导外数据
     * @param startDate 开始时间
     * @return
     */
	List<Personcertificate> searchForExport(String startDate);

	Long dataStatisticsCensorReport(ReportDataSearchDto searchDto);

	List<ReportData> dataStatisticsApprovalReport(ReportDataSearchDto searchDto);

	Long dataStatisticsTestReport(ReportDataSearchDto searchDto);

	Long dataStatisticsPrintReport(ReportDataSearchDto searchDto);

	Long dataStatisticsTestUnPassReport(ReportDataSearchDto searchDto);

	Long countCertificateByCompanyId(Long companyId);

	int countPrintList(Map<Object, Object> p);
    /***
     * 资格证打印查询用于北京
     * @param p
     * @return
     */
    List<Map<Object, Object>> searchPrintListForBj(Map<Object, Object> p);
    /***
     * 资格证打印查询
     * @param p
     * @return
     */
	List<Map<Object, Object>> searchPrintList(Map<Object, Object> p);

	List<PersoncertificateDto> queryTable(PersoncertificateSearchDto searchDto);

	Long queryTableCount(PersoncertificateSearchDto searchDto);

	void insertBatchTemp(List<Personcertificate> list);

	void deleteTempData();

	List<Personcertificate> findUpdateListFromTemp();

	List<Personcertificate> findByNumberIdArr(PersoncertificateSearchDto dto);

	/**
	 * 通过id集合查询保安员证考试报名
	 *
	 * @param dto
	 *            by llc 2018-06-22
	 */
	List<Personcertificate> findByDtoIdArr(PersoncertificateSearchDto dto);

	List<ZTree> getPersonPayTreeByUserId(Long userid);

	/**
	 * 验证身份证是否可重复提交
	 *
	 * @param map
	 * @return
	 */
	Personcertificate checkCarNumRepeat(Map<String, Object> map);

	/**
	 * 批量插入保安员证书临时表 by llc 2018-08-08
	 *
	 * @param list
	 */
	void insertTmpSecurityCertificate(@Param("list") List<Map<String, String>> list, @Param("batchId") int batchId);

	/**
	 * 获取批次ID by llc 2018-08-08
	 *
	 * @param sequence
	 */
	int getNextVal(String sequence);

	/**
	 * 历史保安员证导入存储过程 by llc 2018-08-08
	 * 
	 * @param paramMap
	 */
	Map<String, String> prc_batchImportCertificate(Map<String, Object> paramMap);

	/**
	 * 查询本次导入的校验失败信息 by llc 2018-08-08
	 *
	 * @param batchId
	 */
	List<Map<String, String>> getFailList(int batchId);

	/**
	 * 删除本次导入的保安员信息 by llc 2018-08-08
	 *
	 * @param batchId
	 */
	void deleteTmpSecurityCertificate(int batchId);

	/**
	 * 获取需要新增的考试人员信息
	 *
	 * @param dto
	 * @param page
	 * @return
	 */
	List<ExamSearchDto> query(ExamSearchDto dto, AjaxPageResponse<?> page);

	/**
	 * (内网)批量设置考试人员考场状态为已安排
	 *
	 * @param ids
	 */
	void updateInnerBatchByExamPersonIds(List<Long> ids);

	/**
	 * (外网)批量设置考试人员考场状态为已安排
	 *
	 * @param ids
	 */
	void updateOutBatchByExamPersonIds(List<Long> ids);

	/**
	 * (内网)批量设置考试人员考场状态为未安排
	 *
	 * @param ids
	 */
	void updateInnerBatchCancelByExamPersonIds(List<Long> ids);

	/**
	 * (外网)批量设置考试人员考场状态为未安排
	 *
	 * @param ids
	 */
	void updateOutBatchCancelByExamPersonIds(List<Long> ids);

	List<Personcertificate> findForActivityRepair(@Param("repairType") String repairType);

	/**
	 * 获取考试未安排人员列表，进行课程学习进度同步
	 * 
	 * @return
	 */
	List<String> findLearnRateList();

	/**
	 * 批量更新是否补考状态
	 *
	 * @return
	 */
	void updateIsMakeUp(List<TrainExamPerson> systemExamPersonList);

    List<Personcertificate> findNoCensorStatus();

	/**
	 * 旧数据导入未做背景筛查的
	 * @return
	 */
	List<Personcertificate> findNoCensorForImportOldData();

    /**
     * 根据保安员id查询保安员证申报信息
     * @param personId
     * @return
     */
    Personcertificate findBySecurityPersonId(Long personId);

	List<Personcertificate> findByBatchId(List<Personcertificate> list);

	List<Personcertificate> findByBatchIdWithOutCache(List<Personcertificate> list);


    /****
     * 查询异常数据
     * @return 列表
     */
    List<Personcertificate> findExceptionData();

	List<Personcertificate> findByIdArr(@Param("idArr") Long[] idArr);

	List<Personcertificate> findByIdArrWithOutCache(@Param("idArr") Long[] idArr);

	SAASPersonCerDto getDetailForSAAS(Long id);

	List<SAASPersonCertificateDto> searchForSAASPage(SAASPersonCertificateSearchDto searchDto, AjaxPageResponse<SAASPersonCertificateDto> page);

	/**
	 * 通过保安员id查询待审批、审批中或者审批通过的数据
	 * @param personId
	 * @return
	 */
	Personcertificate findApprovaling(Long personId);

	/**
	 *通过身份证号查询待审批、审批中或者审批通过的数据
	 * @param idNum
	 * @return
	 */
	Personcertificate findApprovalingByIdNum(String idNum);

	/**
	 * 找到已生成证书的保安员（非旧数据）
	 * @param personcertificateList
	 * @return
	 */
    List<Personcertificate> findHasCertificateListByBatchPersonId(@Param("personcertificateList")List<Personcertificate> personcertificateList);

	/**
	 * 根据id取消缴费状态
	 * @param personIds
	 */
    void cancelFeeState(Long[] personIds);

    List<Personcertificate> findCancelFeedStateByIdArr(Long[] personIds);

    List<PersoncertificateDto> searchForPage(PersoncertificateSearchDto dto, AjaxPageResponse<PersoncertificateDto> page);

	/**
	 * 资格证报名信息查询
	 * @param dto
	 * @param page
	 * @return
	 */
	List<VPersoncertificate> searchPage(SearchPersonCertificateDto dto, AjaxPageResponse<VPersoncertificate> page);

	/**
	 * 通过id查询人口地址
	 * @param idArray
	 * @return
	 */
	List<Personcertificate> findAddressByIdArr(Long[] idArray);

	Personcertificate findAddressById(Long id);

	List<GradeAndCertificateDto> selectCertificateSignUpByIds(@Param("personIds")Long[] personIds);
	/**
	 * 通过身份证号码查询保安员资格证书信息
	 * @return
	 */
	List<SecurityCertificate> findCertificateByIdNumber(@Param("areaCode")String nativeCode);

	List<PerconUnRegDto> searchUnRegisterForPage(PersonPageSearchDto dto, AjaxPageResponse<PerconUnRegDto> page);

	//接收百课堂的实操培训材料

	void updateTrainMaterials(@Param("list") List<Personcertificate> list, @Param("material") String material);


	Personcertificate findApprovalingByIdNumForYanAn(String idNum);

	List<Personcertificate> findUnGenerateSubsidyRoster();

	String findUnCensorTime();

	/**
	 * 用于第三方培训平台对接, 查询筛查状态
	 *
	 * @param idNumberList 身份证
	 * @return 身份证/筛查状态
	 */
	List<Personcertificate> findCensorStatusByIdNumbers(@Param("idNumberList") List<String> idNumberList);

	/**
	 * 根据id查询审批通过的
	 *
	 * @param personCertificateList 信息
	 * @return {@link List}
	 */
	List<Personcertificate> findByBatchPersonIdOnApproval(
			@Param("personCertificateList") List<Personcertificate> personCertificateList);

	List<Personcertificate> findUnIntegrated();

	List<VPersoncertificate> searchSubsidyPage(SearchPersonCertificateDto dto, AjaxPageResponse<VPersoncertificate> page);

}
