package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.GradeClassPageSearchDto;
import com.bcxin.ars.dto.sb.GradeClassDto;
import com.bcxin.ars.model.sb.GradeClass;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/***
 * 等级证班级信息
 */
public interface GradeClassDao {
    /***
     * 保存
     * @param record
     * @return
     */
    int insert(GradeClass record);
    /****
     * 批量获取根据ID
     * @param list
     * @return
     */
    List<GradeClass> findByBatchId(List<GradeClass> list);
    /**
     * 批量更新
     * @param  gradeClassList 批量更新
     * @return
     */
    void updateBatch(@Param("gradeClassList") List<GradeClass> gradeClassList);
    /***
     * 更新
     * @param record
     * @return
     */
    int update(GradeClass record);
    /***
     * 根据ID获取详细
     * @param id 主键
     * @return
     */
    GradeClass findById(Long id);

    /***
     * 等级证班级信息查询
     * @param dto 查询条件参数
     * @param ajaxPageResponse 返回数据对象
     * @return 查询列表
     */
    List<GradeClass> query(GradeClassPageSearchDto dto, AjaxPageResponse<GradeClass> ajaxPageResponse);
    /**
     * 查询需要生成同步文件的等级证班级信息
     * @param dto
     * @return
     */
    List<GradeClass> searchForDataSynchronization(DataSynchronizationSearchDto dto);
    /**
     * 内导外数据
     * @param startDate 开始时间
     * @return
     */
    List<GradeClass> searchForExport(String startDate);
    /**
     * 自动更新审批状态
     */
    void autoUpdateApprovalState(String hour);
    /**
     * 新增班级人员信息
     * @param  dto 批量更新
     * @return
     */
    void addPersonClass(GradeClassDto dto);
    /**
     * 删除班级人员信息
     * @param  dto 批量更新
     * @return
     */
    void delPersonClass(GradeClassDto dto);
    /**
     * 取消班级删除人员信息
     * @param  dto 批量更新
     * @return
     */
    void delPersonClassByCancel(GradeClassDto dto);

    /**
     * 更新班级人数
     *
     * @param dto
     */
    void updatePerNum(GradeClassDto dto);

    Long queryUnApprovalCount();

    /**
     * @param dto
     */
    void addPersonClassByIdNumberList(GradeClassDto dto);

    int getByGradeName(String name);


    String getApprovalStateByGradeName(@Param("name") String name,
                                       @Param("trainId") String trainId);

    /**
     * 删除班级成员
     *
     * @param gradeClassDto
     */
    void removePersonClassByIdNumberList(GradeClassDto gradeClassDto);

    /**
     * 通过班级名获取id
     *
     * @param gradeClassDto
     * @return
     */
    Long getClassIdByGradeName(GradeClassDto gradeClassDto);

    /**
     * 根据开班名称更新信息
     *
     * @param gradeClassDto 开班信息
     */
    void updateByGradeClassName(GradeClassDto gradeClassDto);
}