package com.bcxin.ars.dao.msg;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ZTree;
import com.bcxin.ars.dto.msg.NewsnoticeCompanySearchDto;
import com.bcxin.ars.dto.msg.NewsnoticePoliceSearchDto;
import com.bcxin.ars.dto.page.NewsnoticePolicePageSearchDto;
import com.bcxin.ars.model.msg.NewsnoticePolice;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface NewsnoticePoliceDao {

    void delete(NewsnoticePolice record);

    Long save(NewsnoticePolice record);

    NewsnoticePolice findById(Long id);

    void update(NewsnoticePolice record);

    void recall(NewsnoticePolice record);

    List<NewsnoticePolice> search(NewsnoticePoliceSearchDto searchDto);

    Long searchCount(NewsnoticePoliceSearchDto searchDto);

    List<NewsnoticePolice> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    void saveForDS(NewsnoticePolice dbNewsnoticePolice);

    void updateForDS(NewsnoticePolice newsnoticePolice);

    /**
     * 内导外数据
     * @param startDate 开始时间
     * @return
     */
    List<NewsnoticePolice> searchFromInToOutForExport(String startDate);

    /**
     * @Author: wangcy
     * @Description:////阅读数量的数量+1 未阅读数-1
     * @Date: 2018/03/08 0008 10:32
     */
    void batchUpdate(NewsnoticeCompanySearchDto newsnoticeCompany);
    /***
     * 批量更新公司已读消息
     * @param newIds 消息ID
     * @param companyId 公司ID
     */
    void batchUpdateByCompanyId(@Param("newIds")Long[] newIds,@Param("companyId") Long companyId);
    /***
     * 根据消息ID获取公安信息
     * @param idArray ID列表
     * @return
     */
    List<NewsnoticePolice> findBatchForMessageIdSaaS(Long[] idArray);


    /****
     * 获取公安用户列表
     * @param searchDto
     * @return
     */
    List<ZTree> getPoliceUserTree(NewsnoticePoliceSearchDto searchDto);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<NewsnoticePolice> searchForPage(NewsnoticePolicePageSearchDto searchDto, AjaxPageResponse<NewsnoticePolice> page);
}


