package com.bcxin.ars.dao.gen;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.gen.GenTable;
import com.bcxin.ars.dto.page.GenTablePageSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *代码生成业务表Dao
 * @author linqinglin
 * @Date 2020-08-09 08:11:23
 */
public interface GenTableDao {

    /****
     * 删除
     * @param genTable
     * @return
     */
    int delete(GenTable genTable);

    /****
     * 保存
     * @param genTable
     * @return
     */
    int save(GenTable genTable);

    /****
     * 主键查询
     * @param id
     * @return
     */
    GenTable findById(Long id);

    /****
     * 选择修改
     * @param genTable
     * @return
     */
    int updateSelective(GenTable genTable);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<GenTable> searchForPage(GenTablePageSearchDto searchDto, AjaxPageResponse<GenTable> page);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<GenTable> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<GenTable> findByBatchId(@Param("list") List<GenTable> list);

    List<GenTable> selectDbTableListByNames(String[] tableNames);

    List<GenTable> selectDbTableList(GenTable genTable,AjaxPageResponse<GenTable> page);

    GenTable findDetail(Long tableId);

    GenTable selectGenTableByName(String tableName);
}
