package com.bcxin.ars.dao.exam;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.exam.TrainExamInfoDto;
import com.bcxin.ars.dto.exam.TrainExamInfoSearchDto;
import com.bcxin.ars.model.exam.TrainExamInfo;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

public interface TrainExamInfoDao {

	public int insert(TrainExamInfo trainExamInfo);

	public List<TrainExamInfo> list(TrainExamInfo trainExamInfo);

	public List<TrainExamInfoDto> query(TrainExamInfoSearchDto trainExamInfoSearchDto, AjaxPageResponse<?> page);

	public TrainExamInfoDto selectByPrimaryKey(@Param("id") long examID);

	public int updateByPrimaryKey(TrainExamInfo trainExamInfo);

	public int updateExamStateByPrimaryKey(TrainExamInfo trainExamInfo);

	List<TrainExamInfo> findListByExamName(TrainExamInfo trainExamInfo);

	/**
	 * 批量新增修改考试信息
	 * 
	 * @param list
	 * @return
	 */
	public int batchSaveAndUpdate(List<TrainExamInfo> list);

	/**
	 * 导入考试信息数据
	 * 
	 * @param searchDto
	 * @return
	 */
	List<TrainExamInfo> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	/**
	 * 导入数据更新
	 * 
	 * @param trainExamInfo
	 */
	void updateForDS(TrainExamInfo trainExamInfo);

	/**
	 * 导入数据保存
	 * 
	 * @param trainExamInfo
	 */
	void saveForDS(TrainExamInfo trainExamInfo);

	/**
	 * 根据考试主键集合批量返回主键以及更新时间
	 * 
	 * @param list
	 * @return
	 */
	List<TrainExamInfo> getExamInfoUpdate(List<TrainExamInfo> list);
}