package com.bcxin.ars.dao.certificate;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.certificate.TrainCertificateSnapshot;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *培训公司快照保存Dao
 * @author yyx
 * @Date 2020-04-24 16:23:31
 */
public interface TrainCertificateSnapshotDao {

    /****
     * 删除
     * @param trainCertificateSnapshot
     * @return
     */
    int delete(TrainCertificateSnapshot trainCertificateSnapshot);

    /****
     * 保存
     * @param trainCertificateSnapshot
     * @return
     */
    int save(TrainCertificateSnapshot trainCertificateSnapshot);

    /****
     * 新增
     * @param trainCertificateSnapshot
     * @return
     */
    int insert(TrainCertificateSnapshot trainCertificateSnapshot);

    /****
     * 选择性插入
     * @param trainCertificateSnapshot
     * @return
     */
    int insertSelective(TrainCertificateSnapshot trainCertificateSnapshot);

    /****
     * 主键查询
     * @param trainCertificateSnapshot
     * @return
     */
    TrainCertificateSnapshot findByQrCodeId(Long trainCertificateSnapshot);

    /****
     * 修改
     * @param trainCertificateSnapshot
     * @return
     */
    int update(TrainCertificateSnapshot trainCertificateSnapshot);

    /****
     * 选择修改
     * @param trainCertificateSnapshot
     * @return
     */
    int updateSelective(TrainCertificateSnapshot trainCertificateSnapshot);


    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<TrainCertificateSnapshot> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<TrainCertificateSnapshot> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<TrainCertificateSnapshot> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<TrainCertificateSnapshot> findByBatchId(@Param("list") List<TrainCertificateSnapshot> list);
}
