package com.bcxin.ars.dao.certificate;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.certificate.TrainCertificateSearchDto;
import com.bcxin.ars.model.certificate.TrainCertificate;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

public interface TrainCertificateDao {

	/**
	 * 查询
	 * 
	 * @param trainCertificateSearchDto
	 * @return
	 */
	List<TrainCertificate> search(TrainCertificateSearchDto trainCertificateSearchDto, AjaxPageResponse page);
	/**
	 * 查询
	 *
	 * @param trainCertificateSearchDto
	 * @return
	 */
	List<TrainCertificate> searchV1(TrainCertificateSearchDto trainCertificateSearchDto);

	/**
	 * 保存
	 * 
	 * @param trainCertificate
	 * @return
	 */
	Long save(TrainCertificate trainCertificate);

	/**
	 * 删除
	 * 
	 * @param trainCertificate
	 * @return
	 */
	Long delete(TrainCertificate trainCertificate);

	/**
	 * 根据ID查询
	 * 
	 * @param id
	 * @return
	 */
	TrainCertificate findById(Long id);

	/**
	 * 根据公司ID查询
	 * 
	 * @param companyId
	 * @return
	 */
	TrainCertificate findByCompanyId(Long companyId);

	/**
	 * 统计
	 * 
	 * @return
	 */
	long count(TrainCertificateSearchDto dto);

	/**
	 * 更新保安培训公司证书信息
	 * 
	 * @param trainCertificate
	 */
	void update(TrainCertificate trainCertificate);

	/**
	 * 获取当前年度许可证号最大值
	 * 
	 * @param trainCertificateSearchDto
	 * @return
	 */
	String searchMaxXkzhCount(TrainCertificateSearchDto trainCertificateSearchDto);

    List<TrainCertificate> searchUnPdf();

	int insertOrUpdate(TrainCertificate trainCertificate);

	/**
	 * 查询培训公司已经有的公司名字
	 * @return
	 */
	List<String> selectCompanyName();

	/**
	 *  外导内查询
	 * @param searchDto
	 * @return
	 */
    List<TrainCertificate> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	/**
	 * 内导外查询
	 * @param startDate
	 * @return
	 */
	List<TrainCertificate> findDSOutList(String startDate);

	/**
	 * 根据ids批量查询
	 * @param list
	 * @return
	 */
	List<TrainCertificate> findByBatchId(List<TrainCertificate> list);

	/**
	 * 批量保存
	 * @param list
	 */
	void saveBatch(List<TrainCertificate> list);

	List<TrainCertificate> searchForPage(TrainCertificateSearchDto dto, AjaxPageResponse page);
}
