package com.bcxin.ars.dao;

import java.util.List;

import com.bcxin.ars.dto.UserRoleSearchDto;
import com.bcxin.ars.model.UserRole;
import com.bcxin.ars.model.approve.ApproveAreaProDetailPer;

public interface UserRoleDao {

	UserRole findById(long id);

	Long save(UserRole userRole);

	void update(UserRole userRole);

	List<UserRole> search(UserRoleSearchDto dto);

	Long searchCount(UserRoleSearchDto dto);

	void delete(UserRole userRole);

	List<UserRole> findByUserId(Long userid);


	/***
	 * 删除用户与角色关系
	 * @param userid 用户ID
	 * @param roleType 角色类型
	 */
	void deleteByUserIdAndRoleId(long userid,String roleType);

	List<UserRole> findByRoleId(Long roleid);

	List<UserRole> findAll();

	UserRole findByUserIdAndRoleId(Long userid, Long roleid);

	List<UserRole> findByUserIdAndRoleType(Long userid, String roleType);

	List<UserRole> findByRoleIdAndRoleType(Long roleid, String roleType);

	/**
	 * @Author: subh
	 * @Description:批量新增
	 * @Date: 2018/08/26 0023 11:07
	 */
	void batchSave(List<UserRole> userRoleList);

	/**
	 * 根据用户id删除角色
	 * @param id
	 */
    void deleteByUserId(Long id);
}
