package com.bcxin.ars.dao;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.UserDto;
import com.bcxin.ars.dto.UserSearchDto;
import com.bcxin.ars.dto.page.PoliceUserDto;
import com.bcxin.ars.dto.page.UserPageSearchDto;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.model.User;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface UserDao {
	/**
	 *
	 * @Decription:查找所有的公司用户
	 * @author：zhongjianhui
	 * @method  searchAllCompanyUser
	 * @date：2018/6/21 9:26
	 * @params： * @param
	 * @return java.util.List<java.util.Map>
	 */
	List<Map> searchAllCompanyUser(String lastDate,String now);

	User findById(Long id);

	User findByIdWithOutCache(Long id);

	/***
	 * 根据公司ID获取
	 * @param comId
	 * @return
	 */
	User findByComId(Long comId);


	User findByIdForManager(Long id);

	/***
	 * 根据用户名查询用户
	 * @param username
	 * @return
	 */
	User findByUsername(@Param(value = "username") String username,@Param(value = "platform") String platform);
	/***
	 * 根据用户名查询公安和自然人的用户信息
	 * @param username
	 * @return
	 */
	User findByUsernameForPolice(String username);

	User findByUsernameStatus(String username,Boolean active);
	List<User> searchApproveUser(UserSearchDto dto);

	Long searchCountApproveUser(UserSearchDto dto);

	/***
	 * 修改时，判断是否有手机号和用户名有没有重复
	 * @param user 用户
	 * @return
	 */
	User findByUsernameAndId(User user );

	Long save(User user);

	Long saveForDS(User user);

	void delete(User user);

	void updatePassword(User user);

	void update(User user);
	/***
	 * 更新人员登陆状态
	 * @param user
	 */
	void updateLoginState(User user);

	List<User> search(UserSearchDto dto);

	Long searchCount(UserSearchDto dto);

	User checkUseById(Long userid);

	Long findCountByorgid(Long orgid);

	Long findCountByroleid(Long id);

	List<User> searchForDataSynchronization(DataSynchronizationSearchDto dto);

	User findByRawId(Long rawid);

	User findByInRawId(Long inrawid);

	List<User> findAll();

	/**
	 * 更新初始化状态
	 * @param user
	 */
	void updateInitstep(User user);

	void updateXjdUserId(User user);

	List<User> findXjdUserList();
	
	void updateFlag(User user);
	
	void updateAuthMark(User user);

	List<ReportData> findByAreaReport(ReportDataSearchDto searchDto);

	List<User> searchForExport();

	/**
	 * 更新新增修改标志
	 * @param user
	 */
	void updateExportFlag(User user);

    /**
     * 内导外数据
     * @param startDate 开始时间
     * @return
     */
	List<User> searchFromInToOutForExport(String startDate);


	/***
	 * 根据参数查询用户信息
	 * @param user  用户查询条件
	 * @return 用户
	 */
	User find(User user);


	/**
	 * 通过身份证和Id查询
	 * @param
	 */
	List<User> searchByDto(User dto);
    User findByPhone(String phone);

    User findByUsernameAndPlatform(String username);

	Long searchCountByCodeNo(UserSearchDto userSearchDto);

	/**
	 *
	 * @param regexp
	 * @return
	 */
	Long findByUsernameRegexp(String regexp);

	List<User> findByBatchId(@Param("list")List<User> list);

	List<User> findByBatchIdWithOutCache(@Param("list")List<User> list);

	void saveBatch(@Param("list")List<User> list);

	/***
	 * 公安用户管理查询
	 * @param dto 查询条件参数
	 * @param ajaxPageResponse 返回数据对象
	 * @return 查询列表
	 */
	List<PoliceUserDto> searchForPage(UserPageSearchDto dto, AjaxPageResponse<PoliceUserDto> ajaxPageResponse);

    List<User> findErrorPhoto();


	/***
	 * 查询公安用户
	 * @return
	 */
	List<User> findByAllPolice();

	/**
	 * 更新会议状态
	 * @param user
	 */
	void updateConferenceState(User user);

	/**
	 * 查询所有已开通会议的用户
	 * @param userSearchDto 查询参数
	 * @param userDtoAjaxPageResponse 分页数据
	 * @return 列表
	 */
    List<UserDto> searchForAssign(UserSearchDto userSearchDto,
								  AjaxPageResponse<UserDto> userDtoAjaxPageResponse);

	User findByIdNum(@Param("idNum") String idNum, @Param("platform") String platform);
}
